/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2004 Masanao Izumo <iz@onicos.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms timip_of the GNU General Public License as published by
    the Free Software Foundation; either version 2 timip_of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty timip_of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy timip_of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

    tables.h
*/

#ifndef __TIMIP_TABLES_H_
#define __TIMIP_TABLES_H_

#ifdef WIN32
#include "timip_win32.h"
#endif

#ifdef LOOKUP_SINE
extern FLOAT_T timip_lookup_sine(int x);
#else
#include <math.h>
#define timip_lookup_sine(x) (sin((2*M_PI/1024.0) * (x)))
#endif
extern FLOAT_T timip_lookup_triangular(int x);
extern FLOAT_T lookup_log(int x);

#define SINE_CYCLE_LENGTH 1024
LIBTIMIPDLL_API extern int32 timip_freq_table[];
LIBTIMIPDLL_API extern int32 timip_freq_table_zapped[];
LIBTIMIPDLL_API extern int32 timip_freq_table_tuning[][128];
LIBTIMIPDLL_API extern int32 timip_freq_table_pytha[][128];
LIBTIMIPDLL_API extern int32 timip_freq_table_meantone[][128];
LIBTIMIPDLL_API extern int32 timip_freq_table_pureint[][128];
LIBTIMIPDLL_API extern int32 timip_freq_table_user[][48][128];
LIBTIMIPDLL_API extern FLOAT_T *timip_vol_table;
LIBTIMIPDLL_API extern FLOAT_T timip_def_vol_table[];
LIBTIMIPDLL_API extern FLOAT_T timip_gs_vol_table[];
LIBTIMIPDLL_API extern FLOAT_T *timip_xg_vol_table; /* == timip_gs_vol_table */
LIBTIMIPDLL_API extern FLOAT_T *timip_pan_table;
LIBTIMIPDLL_API extern FLOAT_T timip_bend_fine[];
LIBTIMIPDLL_API extern FLOAT_T timip_bend_coarse[];
LIBTIMIPDLL_API extern FLOAT_T timip_midi_time_table[], timip_midi_time_table2[];
#ifdef LOOKUP_HACK
extern uint8 *_l2u; /* 13-bit PCM to 8-bit u-law */
extern uint8 _l2u_[]; /* used in LOOKUP_HACK */
extern int16 _u2l[];
extern int32 *mixup;
#ifdef LOOKUP_INTERPOLATION
extern int8 *iplookup;
#endif
#endif
LIBTIMIPDLL_API extern uint8 timip_reverb_macro_presets[];
LIBTIMIPDLL_API extern uint8 timip_chorus_macro_presets[];
LIBTIMIPDLL_API extern uint8 timip_delay_macro_presets[];
LIBTIMIPDLL_API extern float timip_delay_time_center_table[];
LIBTIMIPDLL_API extern float timip_pre_delay_time_table[];
LIBTIMIPDLL_API extern float timip_chorus_delay_time_table[];
LIBTIMIPDLL_API extern float timip_rate1_table[];
LIBTIMIPDLL_API extern FLOAT_T timip_attack_vol_table[];
LIBTIMIPDLL_API extern FLOAT_T timip_perceived_vol_table[];
LIBTIMIPDLL_API extern FLOAT_T timip_gm2_vol_table[];
LIBTIMIPDLL_API extern FLOAT_T timip_user_vol_table[];
LIBTIMIPDLL_API extern float timip_sc_eg_attack_table[];
LIBTIMIPDLL_API extern float timip_sc_eg_decay_table[];
LIBTIMIPDLL_API extern float timip_sc_eg_release_table[];
LIBTIMIPDLL_API extern FLOAT_T timip_sc_vel_table[];
LIBTIMIPDLL_API extern FLOAT_T timip_sc_vol_table[];
LIBTIMIPDLL_API extern FLOAT_T timip_sc_pan_table[], timip_gm2_pan_table[];
LIBTIMIPDLL_API extern FLOAT_T timip_sc_drum_level_table[];
LIBTIMIPDLL_API extern FLOAT_T timip_sb_vol_table[];
LIBTIMIPDLL_API extern FLOAT_T timip_modenv_vol_table[];
LIBTIMIPDLL_API extern float timip_cb_to_amp_table[];
LIBTIMIPDLL_API extern float timip_reverb_time_table[];
LIBTIMIPDLL_API extern float timip_pan_delay_table[];
LIBTIMIPDLL_API extern float timip_chamberlin_filter_db_to_q_table[];
LIBTIMIPDLL_API extern uint8 timip_multi_eq_block_table_xg[];
LIBTIMIPDLL_API extern float timip_eq_freq_table_xg[];
LIBTIMIPDLL_API extern float timip_lfo_freq_table_xg[];
LIBTIMIPDLL_API extern float timip_mod_delay_offset_table_xg[];
LIBTIMIPDLL_API extern float timip_reverb_time_table_xg[];
LIBTIMIPDLL_API extern float timip_delay_time_table_xg[];
LIBTIMIPDLL_API extern int16 timip_cutoff_freq_table_gs[];
LIBTIMIPDLL_API extern int16 timip_lpf_table_gs[];
LIBTIMIPDLL_API extern int16 timip_eq_freq_table_gs[];
LIBTIMIPDLL_API extern float timip_lofi_sampling_freq_table_xg[];

extern void timip_init_freq_table(void);
extern void timip_init_freq_table_tuning(void);
extern void timip_init_freq_table_pytha(void);
extern void timip_init_freq_table_meantone(void);
extern void timip_init_freq_table_pureint(void);
extern void timip_init_freq_table_user(void);
extern void timip_init_bend_fine(void);
extern void timip_init_bend_coarse(void);
extern void timip_init_tables(void);
extern void timip_init_gm2_pan_table(void);
extern void timip_init_attack_vol_table(void);
extern void timip_init_sb_vol_table(void);
extern void timip_init_modenv_vol_table(void);
extern void timip_init_def_vol_table(void);
extern void timip_init_gs_vol_table(void);
extern void timip_init_perceived_vol_table(void);
extern void timip_init_gm2_vol_table(void);
extern void timip_init_user_vol_table(FLOAT_T power);

#endif /* __TIMIP_TABLES_H_ */
