/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms timip_of the GNU General Public License as published by
    the Free Software Foundation; either version 2 timip_of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty timip_of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy timip_of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __TIMIP_LZH_H_
#define __TIMIP_LZH_H_

#ifdef WIN32
#include "timip_win32.h"
#endif

typedef struct _UNLZHHandler *UNLZHHandler;

extern UNLZHHandler timip_open_unlzh_handler(long (* read_func)(char*,long,void*),
				       const char *method,
				       long compsize, long origsize,
				       void *user_val);
extern long timip_unlzh(UNLZHHandler decoder, char *buff, long buff_size);
extern void timip_close_unlzh_handler(UNLZHHandler decoder);

LIBTIMIPDLL_API extern char *timip_lzh_methods[];

#endif /* __TIMIP_LZH_H_ */
