/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.views.markers.internal.CategoryComparator;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.MarkerFilter;
import org.eclipse.ui.views.markers.internal.MarkerList;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerNode;
import org.eclipse.ui.views.markers.internal.MarkerView;
import org.eclipse.ui.views.markers.internal.SortUtil;
import org.eclipse.ui.views.markers.internal.Util;

public class MarkerAdapter {
    MarkerView view;
    private MarkerList lastMarkers;
    private MarkerCategory[] categories;
    private boolean building = true;

    MarkerAdapter(MarkerView markerView) {
        this.view = markerView;
    }

    public CategoryComparator getCategorySorter() {
        return (CategoryComparator)this.view.getViewer().getComparator();
    }

    public void buildAllMarkers(IProgressMonitor monitor) {
        this.building = true;
        try {
            MarkerList newMarkers;
            int markerLimit;
            block23: {
                markerLimit = this.view.getMarkerLimit();
                monitor.beginTask(MarkerMessages.MarkerView_19, markerLimit == -1 ? 60 : 100);
                try {
                    monitor.subTask(MarkerMessages.MarkerView_waiting_on_changes);
                    if (!monitor.isCanceled()) break block23;
                    return;
                }
                catch (CoreException e) {
                    Policy.handle(e);
                    newMarkers = new MarkerList();
                    return;
                }
            }
            monitor.subTask(MarkerMessages.MarkerView_searching_for_markers);
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 10);
            MarkerFilter[] filters = this.view.getEnabledFilters();
            newMarkers = filters.length > 0 ? MarkerList.compute(filters, (IProgressMonitor)subMonitor, true) : MarkerList.compute(new MarkerFilter[]{this.view.getAllFilters()[0]}, (IProgressMonitor)subMonitor, true);
            if (monitor.isCanceled()) {
                return;
            }
            this.view.refreshMarkerCounts(monitor);
            if (monitor.isCanceled()) {
                return;
            }
            ViewerComparator sorter = this.view.getViewer().getComparator();
            if (markerLimit == -1 || this.isShowingHierarchy()) {
                sorter.sort((Viewer)this.view.getViewer(), (Object[])newMarkers.toArray());
            } else {
                monitor.subTask(MarkerMessages.MarkerView_18);
                SubProgressMonitor mon = new SubProgressMonitor(monitor, 40);
                newMarkers = SortUtil.getFirst(newMarkers, (Comparator)sorter, markerLimit, (IProgressMonitor)mon);
                if (monitor.isCanceled()) {
                    return;
                }
                sorter.sort((Viewer)this.view.getViewer(), (Object[])newMarkers.toArray());
            }
            if (newMarkers.getSize() == 0) {
                this.categories = new MarkerCategory[0];
                this.lastMarkers = newMarkers;
                monitor.done();
                return;
            }
            monitor.subTask(MarkerMessages.MarkerView_queueing_updates);
            if (monitor.isCanceled()) {
                return;
            }
            if (this.isShowingHierarchy()) {
                MarkerCategory[] newCategories = this.buildHierarchy(newMarkers, 0, newMarkers.getSize() - 1, 0);
                if (monitor.isCanceled()) {
                    return;
                }
                this.categories = newCategories;
            }
            this.lastMarkers = newMarkers;
            monitor.done();
        }
        finally {
            this.building = false;
        }
    }

    boolean isShowingHierarchy() {
        ViewerComparator sorter = this.view.getViewer().getComparator();
        if (sorter instanceof CategoryComparator) {
            return ((CategoryComparator)sorter).getCategoryField() != null;
        }
        return false;
    }

    MarkerCategory[] buildHierarchy(MarkerList markers, int start, int end, int sortIndex) {
        CategoryComparator sorter = this.getCategorySorter();
        if (sortIndex > 0) {
            return null;
        }
        ArrayList<MarkerCategory> categories = new ArrayList<MarkerCategory>();
        Object previous = null;
        int categoryStart = start;
        Object[] elements = markers.getArray();
        int i = start;
        while (i <= end) {
            if (previous != null && sorter.compare(previous, elements[i], sortIndex, false) != 0) {
                categories.add(new MarkerCategory(this, categoryStart, i - 1, this.getNameForIndex(markers, categoryStart)));
                categoryStart = i;
            }
            previous = elements[i];
            ++i;
        }
        if (end >= categoryStart) {
            categories.add(new MarkerCategory(this, categoryStart, end, this.getNameForIndex(markers, categoryStart)));
        }
        MarkerCategory[] nodes = new MarkerCategory[categories.size()];
        categories.toArray(nodes);
        return nodes;
    }

    private String getNameForIndex(MarkerList markers, int categoryStart) {
        return this.getCategorySorter().getCategoryField().getValue(markers.toArray()[categoryStart]);
    }

    public MarkerList getCurrentMarkers() {
        if (this.lastMarkers == null) {
            this.view.scheduleMarkerUpdate(100);
            this.building = true;
        }
        if (this.building) {
            return new MarkerList();
        }
        return this.lastMarkers;
    }

    public Object[] getElements() {
        if (this.lastMarkers == null) {
            this.view.scheduleMarkerUpdate(100);
            this.building = true;
        }
        if (this.building) {
            return Util.EMPTY_MARKER_ARRAY;
        }
        if (this.isShowingHierarchy() && this.categories != null) {
            return this.categories;
        }
        return this.lastMarkers.toArray();
    }

    public boolean hasNoMarkers() {
        return this.lastMarkers == null;
    }

    public MarkerCategory[] getCategories() {
        if (this.building) {
            return null;
        }
        return this.categories;
    }

    boolean isBuilding() {
        return this.building;
    }

    class MarkerCategory
    extends MarkerNode {
        MarkerAdapter markerAdapter;
        int start;
        int end;
        private ConcreteMarker[] children;
        private String name;

        MarkerCategory(MarkerAdapter adapter, int startIndex, int endIndex, String categoryName) {
            this.markerAdapter = adapter;
            this.start = startIndex;
            this.end = endIndex;
            this.name = categoryName;
        }

        @Override
        public MarkerNode[] getChildren() {
            if (this.children == null) {
                if (MarkerAdapter.this.building) {
                    return Util.EMPTY_MARKER_ARRAY;
                }
                ConcreteMarker[] allMarkers = this.markerAdapter.lastMarkers.toArray();
                int totalSize = this.getDisplayedSize();
                this.children = new ConcreteMarker[totalSize];
                System.arraycopy(allMarkers, this.start, this.children, 0, totalSize);
                MarkerAdapter.this.view.getTableSorter().sort((Viewer)MarkerAdapter.this.view.getViewer(), this.children);
                int i = 0;
                while (i < this.children.length) {
                    this.children[i].setCategory(this);
                    ++i;
                }
            }
            return this.children;
        }

        int getDisplayedSize() {
            if (MarkerAdapter.this.view.getMarkerLimit() > 0) {
                return Math.min(this.getTotalSize(), MarkerAdapter.this.view.getMarkerLimit());
            }
            return this.getTotalSize();
        }

        @Override
        public MarkerNode getParent() {
            return null;
        }

        @Override
        public String getDescription() {
            int size = this.end - this.start + 1;
            if (size <= MarkerAdapter.this.view.getMarkerLimit()) {
                if (size == 1) {
                    return NLS.bind((String)MarkerMessages.Category_One_Item_Label, (Object[])new Object[]{this.name});
                }
                return NLS.bind((String)MarkerMessages.Category_Label, (Object[])new Object[]{this.name, String.valueOf(this.getDisplayedSize())});
            }
            return NLS.bind((String)MarkerMessages.Category_Limit_Label, (Object[])new Object[]{this.name, String.valueOf(this.getDisplayedSize()), String.valueOf(this.getTotalSize())});
        }

        private int getTotalSize() {
            return this.end - this.start + 1;
        }

        @Override
        public boolean isConcrete() {
            return false;
        }

        @Override
        public ConcreteMarker getConcreteRepresentative() {
            return this.markerAdapter.lastMarkers.getMarker(this.start);
        }

        public String getName() {
            return this.name;
        }
    }
}

