/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.editpart;

import jp.sourceforge.tmdmaker.dialog.ModelEditDialog;
import jp.sourceforge.tmdmaker.dialog.TableEditDialog;
import jp.sourceforge.tmdmaker.editpart.AbstractEntityModelEditPart;
import jp.sourceforge.tmdmaker.editpolicy.EntityLayoutEditPolicy;
import jp.sourceforge.tmdmaker.editpolicy.TMDModelGraphicalNodeEditPolicy;
import jp.sourceforge.tmdmaker.figure.EntityFigure;
import jp.sourceforge.tmdmaker.model.AbstractConnectionModel;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.EntityType;
import jp.sourceforge.tmdmaker.model.MultivalueOrEntity;
import jp.sourceforge.tmdmaker.ui.command.TableDeleteCommand;
import jp.sourceforge.tmdmaker.ui.preferences.appearance.ModelAppearance;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.GroupRequest;

public class MultivalueOrEditPart
extends AbstractEntityModelEditPart<MultivalueOrEntity> {
    public MultivalueOrEditPart(MultivalueOrEntity entity) {
        this.setModel(entity);
    }

    @Override
    protected ModelEditDialog<MultivalueOrEntity> getDialog() {
        return new TableEditDialog<MultivalueOrEntity>(this.getControllShell(), "\u591a\u5024\u306eOR\u8868\u7de8\u96c6", (AbstractEntityModel)this.getModel());
    }

    @Override
    protected void updateFigure(IFigure figure) {
        EntityFigure entityFigure = (EntityFigure)figure;
        MultivalueOrEntity entity = (MultivalueOrEntity)this.getModel();
        entityFigure.setNotImplement(entity.isNotImplement());
        entityFigure.removeAllRelationship();
        entityFigure.setEntityName(entity.getName());
        entityFigure.setEntityType(EntityType.MO.getLabel());
        entityFigure.addRelationship(this.extractRelationship(entity));
        entityFigure.setColor(this.getForegroundColor(), this.getBackgroundColor());
    }

    @Override
    protected ModelAppearance getAppearance() {
        return ModelAppearance.MULTIVALUE_OR;
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new MultivalueOrEntityComponentEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new TMDModelGraphicalNodeEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new EntityLayoutEditPolicy());
    }

    private static class MultivalueOrEntityComponentEditPolicy
    extends ComponentEditPolicy {
        private MultivalueOrEntityComponentEditPolicy() {
        }

        protected Command createDeleteCommand(GroupRequest deleteRequest) {
            MultivalueOrEntity model = (MultivalueOrEntity)this.getHost().getModel();
            return new TableDeleteCommand((AbstractEntityModel)model, (AbstractConnectionModel)model.getModelTargetConnections().get(0));
        }
    }
}

