/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.resources.actions;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.internal.navigator.AdaptabilityUtility;
import org.eclipse.ui.internal.navigator.resources.actions.OpenFolderAsProjectAction;
import org.eclipse.ui.internal.navigator.resources.actions.SelectProjectForFolderAction;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;

public class FoldersAsProjectsActionProvider
extends CommonActionProvider {
    private CommonViewer viewer;

    public void init(ICommonActionExtensionSite aSite) {
        this.viewer = (CommonViewer)aSite.getStructuredViewer();
    }

    public void fillContextMenu(IMenuManager aMenu) {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        if (selection.size() != 1) {
            return;
        }
        Object object = selection.getFirstElement();
        IFolder folder = (IFolder)AdaptabilityUtility.getAdapter((Object)object, IFolder.class);
        if (folder == null) {
            return;
        }
        if (folder.getFile(".project").exists()) {
            IProject[] iProjectArray = folder.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (project.getLocation().equals((Object)folder.getLocation())) {
                    SelectProjectForFolderAction action = new SelectProjectForFolderAction(project, this.viewer);
                    aMenu.appendToGroup("group.open", (IAction)action);
                    return;
                }
                ++n2;
            }
            OpenFolderAsProjectAction action = new OpenFolderAsProjectAction(folder, this.viewer);
            aMenu.prependToGroup("group.port", (IAction)action);
        }
    }
}

