/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model.rule;

import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Attribute;
import jp.sourceforge.tmdmaker.model.Entity;
import jp.sourceforge.tmdmaker.model.EntityType;
import jp.sourceforge.tmdmaker.model.IAttribute;
import jp.sourceforge.tmdmaker.model.rule.ImplementRule;

public class EntityTypeRule {
    private static final String RESOURCE_NAME_LITERAL = "\u540d\u79f0";
    private static final String EVENT_DATE_LITERAL = "\u65e5";

    public static boolean isResource(AbstractEntityModel model) {
        return model.getEntityType().equals((Object)EntityType.RESOURCE);
    }

    public static boolean isEvent(AbstractEntityModel model) {
        return model.getEntityType().equals((Object)EntityType.EVENT);
    }

    public static void addDefaultAttribute(Entity model) {
        Attribute defaultAttribute = new Attribute();
        if (EntityTypeRule.isEvent(model)) {
            defaultAttribute.setName(EntityTypeRule.createEventAttributeName(model.getName()));
            ImplementRule.setEventDefaultAttributeValue(defaultAttribute);
        } else {
            defaultAttribute.setName(EntityTypeRule.createResourceAttributeName(model.getName()));
            ImplementRule.setResourceDefaultAttributeValue(defaultAttribute);
        }
        model.addAttribute(defaultAttribute);
    }

    public static String createResourceAttributeName(String entityName) {
        return String.valueOf(entityName) + RESOURCE_NAME_LITERAL;
    }

    public static String createEventAttributeName(String entityName) {
        if (entityName != null && entityName.length() != 0) {
            return String.valueOf(entityName) + EVENT_DATE_LITERAL;
        }
        return null;
    }

    public static boolean hasDefaultAttributeAlreadyAdded(Entity model) {
        return model.getAttributes().size() > 0;
    }

    public static boolean hasEventAttribute(AbstractEntityModel model) {
        for (IAttribute a : model.getAttributes()) {
            if (!a.getName().endsWith(EVENT_DATE_LITERAL)) continue;
            return true;
        }
        return false;
    }
}

