/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id: library.h 266 2010-03-01 02:28:53Z sirakaba $
*******************************************************************************/

//******************************************************************************
//    Includes
//******************************************************************************

#include "../header/plugin.h"
#include <wx/file.h>

//******************************************************************************
//    Functions
//******************************************************************************

wxString MakeCommandLineSend(wxString szCommandLine, wxString szArcName, TPI_SWITCHES * swInfo, wxArrayString asFiles, wxString szResponceFileName);
wxString MakeResponceFile(wxArrayString asFiles, bool bQuote);
wxString MB2String(const char * sz);
wxString UTF82String(const char * sz);
wxString WC2String(const wchar_t * sz);

#include <wx/xml/xml.h>
#ifndef WXWIN_COMPATIBILITY_2_8
#define GetAttribute GetPropVal
#define HasAttribute HasProp
#endif

#define CheckSupportedCommand(attr, value) if (xmlLibrary->HasAttribute(wxT(attr)) || xmlLibrary->HasAttribute(wxT(attr) wxT("-alt"))) _fiInfo->eSupportedCommand |= value
#define CheckSupportedSwitch(var,   value) value = szCmdLine.Find(wxT(var)) != wxNOT_FOUND

inline short GetNumValue(wxXmlNode * node, wxString szValue)
{
	long l;
	node->GetAttribute(szValue, wxT("0")).ToLong(& l);
	return (short) l;
}

inline void MakeFormatInfo(wxString szTPIName, TPI_FORMATINFO * _fiInfo, wxXmlNode * xmlLibrary, wxULongLong_t nId)
{
	_fiInfo->fArchive       = xmlLibrary->GetAttribute(wxT("archive"), wxT("1")) == wxT("1");
	_fiInfo->szTypeName     = xmlLibrary->GetAttribute(wxT("typename"),wxEmptyString);
	_fiInfo->szSuffix       = xmlLibrary->GetAttribute(wxT("suffix"),  wxEmptyString);
	_fiInfo->szEngineName   = xmlLibrary->GetAttribute(wxT("name"),    wxEmptyString);
	_fiInfo->szTPIName      = szTPIName;
	_fiInfo->nTypeId        = nId;

	// 対応コマンドを調査。
	CheckSupportedCommand("create", TPI_COMMAND_CREATE);
	CheckSupportedCommand("add",    TPI_COMMAND_ADD);
	CheckSupportedCommand("extract",TPI_COMMAND_EXTRACT);
	CheckSupportedCommand("delete", TPI_COMMAND_DELETE);
	CheckSupportedCommand("update", TPI_COMMAND_UPDATE);
	CheckSupportedCommand("test",   TPI_COMMAND_TEST);
	CheckSupportedCommand("repair", TPI_COMMAND_REPAIR);
	CheckSupportedCommand("move",   TPI_COMMAND_MOVE);
	CheckSupportedCommand("sfx",    TPI_COMMAND_SFX);
	CheckSupportedCommand("unsfx",  TPI_COMMAND_UNSFX);

	// 対応スイッチを調査。
	wxString szCmdLine =
		xmlLibrary->HasAttribute(wxT("create"))      ? xmlLibrary->GetAttribute(wxT("create"),      wxEmptyString) :
		xmlLibrary->HasAttribute(wxT("create-alt"))  ? xmlLibrary->GetAttribute(wxT("create-alt"),  wxEmptyString) :
		xmlLibrary->HasAttribute(wxT("extract"))     ? xmlLibrary->GetAttribute(wxT("extract"),     wxEmptyString) :
		xmlLibrary->HasAttribute(wxT("extract-alt")) ? xmlLibrary->GetAttribute(wxT("extract-alt"), wxEmptyString) :
		(wxString) wxEmptyString;
	CheckSupportedSwitch("96", _fiInfo->fComment);
	CheckSupportedSwitch("a1", _fiInfo->fSFX);
	CheckSupportedSwitch("a2", _fiInfo->fSolid);
	CheckSupportedSwitch("a3", _fiInfo->fMMOptimize);
	CheckSupportedSwitch("a4", _fiInfo->fEncryptHeader);
	CheckSupportedSwitch("a5", _fiInfo->fEncryptPassword);
	CheckSupportedSwitch("a6", _fiInfo->fEncryptKeyFile);
	CheckSupportedSwitch("a7", _fiInfo->fMultiVolume);
	CheckSupportedSwitch("a8", _fiInfo->fCompressHeader);

	_fiInfo->nCompressLevelMin  = GetNumValue(xmlLibrary, wxT("level-min"));
	_fiInfo->nCompressLevelMax  = GetNumValue(xmlLibrary, wxT("level-max"));
	_fiInfo->nRecoveryRecordMin = GetNumValue(xmlLibrary, wxT("rr-min"));
	_fiInfo->nRecoveryRecordMax = GetNumValue(xmlLibrary, wxT("rr-max"));
}
