#
# SYNOPSIS
#
#   TSU_CHECK_XELATEX_FONT([FONTNAME],[OPTIONS])
#
# DESCRIPTION
#
#   Check whether XeLaTeX and fontspec are capable of loading a specific
#   font.  If so, the variable xelatex_font_found is set to yes.
#
# LICENSE
#
#   This macro is released to the public domain by its author,
#   Matthew Skala <mskala@ansuz.sooke.bc.ca>.

#serial 4

AC_DEFUN([TSU_CHECK_XELATEX_FONT],[dnl
  AS_IF([test 'x' = 'x$2'],
    [AC_MSG_CHECKING([for $1 in XeLaTeX])],
    [AC_MSG_CHECKING([for $1 in XeLaTeX with $2])])
  cat <<EOF > tcxftmp.tex
\documentclass{article}
\usepackage{fontspec}
\setmainfont[[$2]]{$1}
\begin{document}
\end{document}
EOF
  AS_IF(["$XELATEX" ./tcxftmp.tex > /dev/null 2> /dev/null],
    [AC_MSG_RESULT([yes])
     xelatex_font_found=yes],
    [AC_MSG_RESULT([no])
     xelatex_font_found=no])
  rm -f missfont.log tcxftmp.*
])
