#
# SYNOPSIS
#
#   TSU_FIX_CONFIG_STATUS
#
# DESCRIPTION
#
#   Modify the config.status file to make it filter certain "include" lines
#   out of the Makefile when processing the Makefile for use in depfile
#   generation.  This is necessary because Automake 15.1 introduced a
#   drastic change in depfile generation: formerly, it used sed to extract
#   only the recipes needed for depfile generation, whereas now it attempts
#   to run Make on basically the entire Makefile during configuration.  In
#   the case of Tsukurimashou, this change has the effect of spinning up the
#   whole build system to generate expensive include files needed for
#   generating the actual fonts, and since configure is still in progress at
#   that point, the effort to generate those files fails and ends up
#   creating an infinite loop.
#
# LICENSE
#
#   This macro is released to the public domain by its author,
#   Matthew Skala <mskala@ansuz.sooke.bc.ca>.

#serial 1

AC_DEFUN([TSU_FIX_CONFIG_STATUS], [
  AC_CONFIG_COMMANDS_POST([
    AC_MSG_NOTICE([fixing config.status])
    "$PERL" -i -pe 's/\| \$MAKE -f - am--depfiles/|  grep -v dnl
      "^include makefile" | \$MAKE -f - am--depfiles/' config.status
  ])
])
