<?php
/**
 * @file
 * @package regpay
 * @version $Id$
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/regpay/class/AbstractDeleteAction.class.php";

class Regpay_Admin_PaypalamountDeleteAction extends Regpay_AbstractDeleteAction
{
	/**
	 * @protected
	 */
	function &_getId()
	{
		return xoops_getrequest('paypalamount_id');
	}

	/**
	 * @protected
	 */
	function &_getHandler()
	{
		$handler =& $this->mAsset->load('handler', "paypalamount");
		return $handler;
	}

	/**
	 * @protected
	 */
	function &_setupActionForm()
	{
		// $this->mActionForm =& new Regpay_Admin_PaypalamountDeleteForm();
		$this->mActionForm =& $this->mAsset->create('form', "admin.delete_paypalamount");
		$this->mActionForm->prepare();
	}

	/**
	 * @public
	 */
	function executeViewInput(&$render)
	{
		$render->setTemplateName("paypalamount_delete.html");
		$render->setAttribute('actionForm', $this->mActionForm);
		#cubson::lazy_load('paypalamount', $this->mObject);
		$render->setAttribute('object', $this->mObject);

	}

	/**
	 * @public
	 */
	function executeViewSuccess(&$render)
	{
		$this->mRoot->mController->executeForward("./index.php?action=PaypalamountList");
	}

	/**
	 * @public
	 */
	function executeViewError(&$render)
	{
		$this->mRoot->mController->executeRedirect("./index.php?action=PaypalamountList", 1, _MD_REGPAY_ERROR_DBUPDATE_FAILED);
	}

	/**
	 * @public
	 */
	function executeViewCancel(&$render)
	{
		$this->mRoot->mController->executeForward("./index.php?action=PaypalamountList");
	}
}

?>
