<?php
/**
 * @file
 * @package regpay
 * @version $Id$
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_ROOT_PATH . "/core/XCube_ActionForm.class.php";
require_once XOOPS_MODULE_PATH . "/legacy/class/Legacy_Validator.class.php";

class Regpay_Admin_PaypalpdtEditForm extends XCube_ActionForm
{
	/**
	 * @public
	 */
	public function validatepaymentdate()
    {
    	$datetime = $this->get('paymentdate');
        $this->set('paymentdate', strtotime($datetime));
    }

	function getTokenName()
	{
		return "module.regpay.Admin_PaypalpdtEditForm.TOKEN";
	}

	/**
	 * @public
	 */
	function prepare()
	{
		//
		// Set form properties
		//
		$this->mFormProperties['paypalpdt_id'] =& new XCube_IntProperty('paypalpdt_id');
		$this->mFormProperties['firstname'] =& new XCube_StringProperty('firstname');
		$this->mFormProperties['lastname'] =& new XCube_StringProperty('lastname');
		$this->mFormProperties['item_name'] =& new XCube_StringProperty('item_name');
		$this->mFormProperties['amount'] =& new XCube_IntProperty('amount');
		$this->mFormProperties['payment_status'] =& new XCube_StringProperty('payment_status');
		$this->mFormProperties['tax'] =& new XCube_IntProperty('tax');
		$this->mFormProperties['payer_email'] =& new XCube_StringProperty('payer_email');
		$this->mFormProperties['uid'] =& new XCube_IntProperty('uid');
		$this->mFormProperties['paymentdate'] =& new XCube_StringProperty('paymentdate');

		//
		// Set field properties
		//
		$this->mFieldProperties['paypalpdt_id'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['paypalpdt_id']->setDependsByArray(array('required'));
		$this->mFieldProperties['paypalpdt_id']->addMessage('required', _MD_REGPAY_ERROR_REQUIRED, _MD_REGPAY_LANG_PAYPALPDT_ID);

		$this->mFieldProperties['firstname'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['firstname']->setDependsByArray(array('required','maxlength'));
		$this->mFieldProperties['firstname']->addMessage('required', _MD_REGPAY_ERROR_REQUIRED, _MD_REGPAY_LANG_FIRSTNAME, '60');
		$this->mFieldProperties['firstname']->addMessage('maxlength', _MD_REGPAY_ERROR_MAXLENGTH, _MD_REGPAY_LANG_FIRSTNAME, '60');
		$this->mFieldProperties['firstname']->addVar('maxlength', '60');

		$this->mFieldProperties['lastname'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['lastname']->setDependsByArray(array('required','maxlength'));
		$this->mFieldProperties['lastname']->addMessage('required', _MD_REGPAY_ERROR_REQUIRED, _MD_REGPAY_LANG_LASTNAME, '60');
		$this->mFieldProperties['lastname']->addMessage('maxlength', _MD_REGPAY_ERROR_MAXLENGTH, _MD_REGPAY_LANG_LASTNAME, '60');
		$this->mFieldProperties['lastname']->addVar('maxlength', '60');

		$this->mFieldProperties['item_name'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['item_name']->setDependsByArray(array('required','maxlength'));
		$this->mFieldProperties['item_name']->addMessage('required', _MD_REGPAY_ERROR_REQUIRED, _MD_REGPAY_LANG_ITEM_NAME, '64');
		$this->mFieldProperties['item_name']->addMessage('maxlength', _MD_REGPAY_ERROR_MAXLENGTH, _MD_REGPAY_LANG_ITEM_NAME, '64');
		$this->mFieldProperties['item_name']->addVar('maxlength', '64');

		$this->mFieldProperties['amount'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['amount']->setDependsByArray(array('required'));
		$this->mFieldProperties['amount']->addMessage('required', _MD_REGPAY_ERROR_REQUIRED, _MD_REGPAY_LANG_AMOUNT);

		$this->mFieldProperties['payment_status'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['payment_status']->setDependsByArray(array('required','maxlength'));
		$this->mFieldProperties['payment_status']->addMessage('required', _MD_REGPAY_ERROR_REQUIRED, _MD_REGPAY_LANG_PAYMENT_STATUS, '32');
		$this->mFieldProperties['payment_status']->addMessage('maxlength', _MD_REGPAY_ERROR_MAXLENGTH, _MD_REGPAY_LANG_PAYMENT_STATUS, '32');
		$this->mFieldProperties['payment_status']->addVar('maxlength', '32');

		$this->mFieldProperties['tax'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['tax']->setDependsByArray(array('required'));
		$this->mFieldProperties['tax']->addMessage('required', _MD_REGPAY_ERROR_REQUIRED, _MD_REGPAY_LANG_TAX);

		$this->mFieldProperties['payer_email'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['payer_email']->setDependsByArray(array('required','maxlength'));
		$this->mFieldProperties['payer_email']->addMessage('required', _MD_REGPAY_ERROR_REQUIRED, _MD_REGPAY_LANG_PAYER_EMAIL, '64');
		$this->mFieldProperties['payer_email']->addMessage('maxlength', _MD_REGPAY_ERROR_MAXLENGTH, _MD_REGPAY_LANG_PAYER_EMAIL, '64');
		$this->mFieldProperties['payer_email']->addVar('maxlength', '64');

		$this->mFieldProperties['uid'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['uid']->setDependsByArray(array('required'));
		$this->mFieldProperties['uid']->addMessage('required', _MD_REGPAY_ERROR_REQUIRED, _MD_REGPAY_LANG_UID);

		$this->mFieldProperties['paymentdate'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['paymentdate']->setDependsByArray(array('required'));
		$this->mFieldProperties['paymentdate']->addMessage('required', _MD_REGPAY_ERROR_REQUIRED, _MD_REGPAY_LANG_PAYMENTDATE);
	}

	/**
	 * @public
	 */
	function load(&$obj)
	{
		$this->set('paypalpdt_id', $obj->get('paypalpdt_id'));
		$this->set('firstname', $obj->get('firstname'));
		$this->set('lastname', $obj->get('lastname'));
		$this->set('item_name', $obj->get('item_name'));
		$this->set('amount', $obj->get('amount'));
		$this->set('payment_status', $obj->get('payment_status'));
		$this->set('tax', $obj->get('tax'));
		$this->set('payer_email', $obj->get('payer_email'));
		$this->set('uid', $obj->get('uid'));
		$this->set('paymentdate', $obj->get('paymentdate'));
	}

	/**
	 * @public
	 */
	function update(&$obj)
	{
		$obj->set('paypalpdt_id', $this->get('paypalpdt_id'));
		$obj->set('firstname', $this->get('firstname'));
		$obj->set('lastname', $this->get('lastname'));
		$obj->set('item_name', $this->get('item_name'));
		$obj->set('amount', $this->get('amount'));
		$obj->set('payment_status', $this->get('payment_status'));
		$obj->set('tax', $this->get('tax'));
		$obj->set('payer_email', $this->get('payer_email'));
		$obj->set('uid', $this->get('uid'));
		$obj->set('paymentdate', $this->get('paymentdate'));
	}
}

?>
