<?php
/**
 * @file
 * @package regpay
 * @version $Id$
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/regpay/class/AbstractFilterForm.class.php";

define('REGPAY_PAYPALPDT_SORT_KEY_PAYPALPDT_ID', 1);
define('REGPAY_PAYPALPDT_SORT_KEY_FIRSTNAME', 2);
define('REGPAY_PAYPALPDT_SORT_KEY_LASTNAME', 3);
define('REGPAY_PAYPALPDT_SORT_KEY_ITEM_NAME', 4);
define('REGPAY_PAYPALPDT_SORT_KEY_AMOUNT', 5);
define('REGPAY_PAYPALPDT_SORT_KEY_PAYMENT_STATUS', 6);
define('REGPAY_PAYPALPDT_SORT_KEY_TAX', 7);
define('REGPAY_PAYPALPDT_SORT_KEY_PAYER_EMAIL', 8);
define('REGPAY_PAYPALPDT_SORT_KEY_UID', 9);
define('REGPAY_PAYPALPDT_SORT_KEY_PAYMENTDATE', 10);
define('REGPAY_PAYPALPDT_SORT_KEY_DEFAULT', REGPAY_PAYPALPDT_SORT_KEY_PAYPALPDT_ID);

class Regpay_Admin_PaypalpdtFilterForm extends Regpay_AbstractFilterForm
{
	var $mSortKeys = array(
		REGPAY_PAYPALPDT_SORT_KEY_PAYPALPDT_ID => 'paypalpdt_id',
		REGPAY_PAYPALPDT_SORT_KEY_FIRSTNAME => 'firstname',
		REGPAY_PAYPALPDT_SORT_KEY_LASTNAME => 'lastname',
		REGPAY_PAYPALPDT_SORT_KEY_ITEM_NAME => 'item_name',
		REGPAY_PAYPALPDT_SORT_KEY_AMOUNT => 'amount',
		REGPAY_PAYPALPDT_SORT_KEY_PAYMENT_STATUS => 'payment_status',
		REGPAY_PAYPALPDT_SORT_KEY_TAX => 'tax',
		REGPAY_PAYPALPDT_SORT_KEY_PAYER_EMAIL => 'payer_email',
		REGPAY_PAYPALPDT_SORT_KEY_UID => 'uid',
		REGPAY_PAYPALPDT_SORT_KEY_PAYMENTDATE => 'paymentdate'
	);

	/**
	 * @public
	 */
	function getDefaultSortKey()
	{
		return REGPAY_PAYPALPDT_SORT_KEY_DEFAULT;
	}

	/**
	 * @public
	 */
	function fetch()
	{
		parent::fetch();
	
		$root =& XCube_Root::getSingleton();
	
		if (($value = $root->mContext->mRequest->getRequest('paypalpdt_id')) !== null) {
			$this->mNavi->addExtra('paypalpdt_id', $value);
			$this->_mCriteria->add(new Criteria('paypalpdt_id', $value));
		}
	
		if (($value = $root->mContext->mRequest->getRequest('firstname')) !== null) {
			$this->mNavi->addExtra('firstname', $value);
			$this->_mCriteria->add(new Criteria('firstname', $value));
		}
	
		if (($value = $root->mContext->mRequest->getRequest('lastname')) !== null) {
			$this->mNavi->addExtra('lastname', $value);
			$this->_mCriteria->add(new Criteria('lastname', $value));
		}
	
		if (($value = $root->mContext->mRequest->getRequest('item_name')) !== null) {
			$this->mNavi->addExtra('item_name', $value);
			$this->_mCriteria->add(new Criteria('item_name', $value));
		}
	
		if (($value = $root->mContext->mRequest->getRequest('amount')) !== null) {
			$this->mNavi->addExtra('amount', $value);
			$this->_mCriteria->add(new Criteria('amount', $value));
		}
	
		if (($value = $root->mContext->mRequest->getRequest('payment_status')) !== null) {
			$this->mNavi->addExtra('payment_status', $value);
			$this->_mCriteria->add(new Criteria('payment_status', $value));
		}
	
		if (($value = $root->mContext->mRequest->getRequest('tax')) !== null) {
			$this->mNavi->addExtra('tax', $value);
			$this->_mCriteria->add(new Criteria('tax', $value));
		}
	
		if (($value = $root->mContext->mRequest->getRequest('payer_email')) !== null) {
			$this->mNavi->addExtra('payer_email', $value);
			$this->_mCriteria->add(new Criteria('payer_email', $value));
		}
	
		if (($value = $root->mContext->mRequest->getRequest('uid')) !== null) {
			$this->mNavi->addExtra('uid', $value);
			$this->_mCriteria->add(new Criteria('uid', $value));
		}
	
		if (($value = $root->mContext->mRequest->getRequest('paymentdate')) !== null) {
			$this->mNavi->addExtra('paymentdate', $value);
			$this->_mCriteria->add(new Criteria('paymentdate', $value));
		}
	
		$this->_mCriteria->addSort($this->getSort(), $this->getOrder());
	}
}

?>
