<?php
// 
// WHLX CMS - postingxml.php
// 
// 20040417 - 0.00 alpha
// 




// WHLX_PostingXML_DataChecker_Article  ( $error, $message, $form );    
// // 
function  WHLX_PostingXML_DataChecker_Article  ( &$error, &$message, &$form )
{
	$error   =  0;
	$message =  "\r\n";

	// Error
	if( $form[ 'title'     ] == ''                                        ){ $error |= 1;    $message .= "\t\t".  'ERROR     : 表題       が未入力です. <br /> '.  "\r\n"; }
	if( $form[ 'text'      ] == ''                                        ){ $error |= 1;    $message .= "\t\t".  'ERROR     : 本文       が未入力です. <br /> '.  "\r\n"; }
	if( $form[ 'creator'   ] == ''                                        ){ $error |= 1;    $message .= "\t\t".  'ERROR     : 筆者名     が未入力です. <br /> '.  "\r\n"; }
	if( !WHLX_PasswordChecker( $form[ 'password' ], $form[ 'pw_crypt' ] ) ){ $error |= 1;    $message .= "\t\t".  'ERROR     : パスワード が違います.   <br /> '.  "\r\n"; }

	if( $error == 0 )                                                      {                 $message .= "\t\t".  'SUCCEEDED : 書き込みに成功しました.  <br /> '.  "\r\n";    return true;  }
	else                                                                   {                 $message .= "\t\t".  'FAILED    : 書き込みに失敗しました.  <br /> '.  "\r\n";    return false; }
}




// WHLX_PostingXML_DataChecker_Comment  ( $error, $message, $form );    
// // 
function  WHLX_PostingXML_DataChecker_Comment  ( &$error, &$message, &$form )
{
	$error   =  0;
	$message =  "\r\n";

	// Error
	if( $form[ 'id'        ] == ''                                        ){ $error |= 1;    $message .= "\t\t".  'ERROR     : 記事 ID   が未入力です.  <br /> '.  "\r\n"; }
	if( $form[ 'title'     ] == ''                                        ){ $error |= 1;    $message .= "\t\t".  'ERROR     : 表題      が未入力です.  <br /> '.  "\r\n"; }
	if( $form[ 'excerpt'   ] == ''                                        ){ $error |= 1;    $message .= "\t\t".  'ERROR     : 本文      が未入力です.  <br /> '.  "\r\n"; }
	if( $form[ 'blog_name' ] == ''                                        ){ $error |= 1;    $message .= "\t\t".  'ERROR     : 送信者名  が未入力です.  <br /> '.  "\r\n"; }

	// Warning
//	if( $form[ 'url'       ] == ''                                        ){ $error |= 0;    $message .= "\t\t".  'WARNING   : 送信元URL が未入力です.  <br /> '.  "\r\n"; }
	$form[ 'url'       ] =  '';

	if( $error == 0 )                                                      {                 $message .= "\t\t".  'SUCCEEDED : 書き込みに成功しました.  <br /> '.  "\r\n";    return true;  }
	else                                                                   {                 $message .= "\t\t".  'FAILED    : 書き込みに失敗しました.  <br /> '.  "\r\n";    return false; }
}




// WHLX_PostingXML_DataChecker_Trackback( $error, $message, $form );    
// // 
function  WHLX_PostingXML_DataChecker_Trackback( &$error, &$message, &$form )
{
	$error   =  0;
	$message =  "\r\n";

	// Error
	if( $form[ 'id'        ] == ''                                        ){ $error |= 1;    $message .= "\t\t".  'ERROR     : 記事 ID   が未入力です.   <br /> '.  "\r\n"; }
	if( $form[ 'url'       ] == ''                                        ){ $error |= 1;    $message .= "\t\t".  'ERROR     : 送信元URL が未入力です.   <br /> '.  "\r\n"; }

	// Warning
	if( $form[ 'title'     ] == ''                                        ){ $error |= 0;    $message .= "\t\t".  'WARNING   : 表題      が未入力です.   <br /> '.  "\r\n";    $form[ 'title'     ] =  $form[ 'url' ]; }
	if( $form[ 'excerpt'   ] == ''                                        ){ $error |= 0;    $message .= "\t\t".  'WARNING   : 本文      が未入力です.   <br /> '.  "\r\n";    $form[ 'excerpt'   ] =  $form[ 'url' ]; }
	if( $form[ 'blog_name' ] == ''                                        ){ $error |= 0;    $message .= "\t\t".  'WARNING   : 送信者名  が未入力です.   <br /> '.  "\r\n";    $form[ 'blog_name' ] =  $form[ 'url' ]; }

	if( $error == 0 )                                                      {                 $message .= "\t\t".  'SUCCEEDED : 書き込みに成功しました.   <br /> '.  "\r\n";    return true;  }
	else                                                                   {                 $message .= "\t\t".  'FAILED    : 書き込みに失敗しました.   <br /> '.  "\r\n";    return false; }
}




// WHLX_PostingXML_DataChecker_Image    ( $error, $message, $form, $file );    
// // 
function  WHLX_PostingXML_DataChecker_Image    ( &$error, &$message, &$form, &$file )
{
	$error   =  0;
	$message =  "\r\n";

	// Error : 記事内容チェック
	if( $form[ 'title'     ] == ''                                        ){ $error |= 1;    $message .= "\t\t".  'ERROR     : 表題       が未入力です.  <br /> '.  "\r\n"; }
	if( $form[ 'text'      ] == ''                                        ){ $error |= 1;    $message .= "\t\t".  'ERROR     : 本文       が未入力です.  <br /> '.  "\r\n"; }
	if( $form[ 'creator'   ] == ''                                        ){ $error |= 1;    $message .= "\t\t".  'ERROR     : 筆者名     が未入力です.  <br /> '.  "\r\n"; }
	if( !WHLX_PasswordChecker( $form[ 'password' ], $form[ 'pw_crypt' ] ) ){ $error |= 1;    $message .= "\t\t".  'ERROR     : パスワード が違います.    <br /> '.  "\r\n"; }

	// Error : ファイル内容チェック
	if( $form[ '_FILES' ][ 'file' ][ 'name'     ] == ''            )       { $error |= 1;    $message .= "\t\t".  'ERROR     : ファイル名 が未入力です.  <br /> '.  "\r\n"; }
	if( $form[ '_FILES' ][ 'file' ][ 'type'     ] == ''            )       { $error |= 1;    $message .= "\t\t".  'ERROR     : ファイルの種類が不正です. <br /> '.  "\r\n"; }
	if( $form[ '_FILES' ][ 'file' ][ 'size'     ] == ''            )       { $error |= 1;    $message .= "\t\t".  'ERROR     : ファイルが大き過ぎます.   <br /> '.  "\r\n"; }
	if( $form[ '_FILES' ][ 'file' ][ 'tmp_name' ] == ''            )       { $error |= 1;    $message .= "\t\t".  'ERROR     : 受信側のエラーです.       <br /> '.  "\r\n"; }
//	if( $form[ '_FILES' ][ 'file' ][ 'error'    ] != UPLOAD_ERR_OK )       { $error |= 1;    $message .= "\t\t".  'ERROR     : エラーが発生しました.     <br /> '.  "\r\n"; }


	// 画像ファイルの内容をチェックします. 
	$image =  getimagesize( $form[ '_FILES' ][ 'file' ][ 'tmp_name' ] );
	switch( $image[ 2 ] )
	{
	//	case  0: $file[ 'mime' ] =  'image/unknown'; break;
		case  1: $file[ 'mime' ] =  'image/gif';     break;
		case  2: $file[ 'mime' ] =  'image/jpeg';    break;
		case  3: $file[ 'mime' ] =  'image/png';     break;
		case  4: $file[ 'mime' ] =  'image/swf';     break;
		case  5: $file[ 'mime' ] =  'image/psd';     break;
		case  6: $file[ 'mime' ] =  'image/bmp';     break;
		case  7: $file[ 'mime' ] =  'image/tiff';    break;

		default: // $file[ 'mime' ] =  'image/unknown'; break;
		$error   |= 1;
		$message .= "\t\tERROR     : ファイルの種類が不正です.             <br /> \r\n";
		break;
	}

	$file[ 'name'   ] =  $form[ '_FILES' ][ 'file' ][ 'name'     ];
	$file[ 'type'   ] =  $form[ '_FILES' ][ 'file' ][ 'type'     ];
	$file[ 'size'   ] =  $form[ '_FILES' ][ 'file' ][ 'size'     ];
	$file[ 'tmp'    ] =  $form[ '_FILES' ][ 'file' ][ 'tmp_name' ];
	$file[ 'source' ] =  '';
	$file[ 'width'  ] =  sprintf( '%d', $image[ 0 ] );
	$file[ 'height' ] =  sprintf( '%d', $image[ 1 ] );


	if( $error == 0 )                                                      {                 $message .= "\t\t".  'SUCCEEDED : 書き込みに成功しました.   <br /> '.  "\r\n";    return true;  }
	else                                                                   {                 $message .= "\t\t".  'FAILED    : 書き込みに失敗しました.   <br /> '.  "\r\n";    return false; }
}




// WHLX_PostingXML_DataChecker_Upload   ( $error, $message, $form, $file );    
// // 
function  WHLX_PostingXML_DataChecker_Upload   ( &$error, &$message, &$form, &$file )
{
	$error   =  0;
	$message =  "\r\n";

	// Error : 記事内容チェック
	if( $form[ 'title'     ] == ''                                        ){ $error |= 1;    $message .= "\t\t".  'ERROR     : 表題       が未入力です.  <br /> '.  "\r\n"; }
	if( $form[ 'text'      ] == ''                                        ){ $error |= 1;    $message .= "\t\t".  'ERROR     : 本文       が未入力です.  <br /> '.  "\r\n"; }
	if( $form[ 'creator'   ] == ''                                        ){ $error |= 1;    $message .= "\t\t".  'ERROR     : 筆者名     が未入力です.  <br /> '.  "\r\n"; }
	if( !WHLX_PasswordChecker( $form[ 'password' ], $form[ 'pw_crypt' ] ) ){ $error |= 1;    $message .= "\t\t".  'ERROR     : パスワード が違います.    <br /> '.  "\r\n"; }

	// Error : ファイル内容チェック
	if( $form[ '_FILES' ][ 'file' ][ 'name'     ] == ''            )       { $error |= 1;    $message .= "\t\t".  'ERROR     : ファイル名 が未入力です.  <br /> '.  "\r\n"; }
	if( $form[ '_FILES' ][ 'file' ][ 'type'     ] == ''            )       { $error |= 1;    $message .= "\t\t".  'ERROR     : ファイルの種類が不正です. <br /> '.  "\r\n"; }
	if( $form[ '_FILES' ][ 'file' ][ 'size'     ] == ''            )       { $error |= 1;    $message .= "\t\t".  'ERROR     : ファイルが大き過ぎます.   <br /> '.  "\r\n"; }
	if( $form[ '_FILES' ][ 'file' ][ 'tmp_name' ] == ''            )       { $error |= 1;    $message .= "\t\t".  'ERROR     : 受信側のエラーです.       <br /> '.  "\r\n"; }
//	if( $form[ '_FILES' ][ 'file' ][ 'error'    ] != UPLOAD_ERR_OK )       { $error |= 1;    $message .= "\t\t".  'ERROR     : エラーが発生しました.     <br /> '.  "\r\n"; }

	$file[ 'name'   ] =  $form[ '_FILES' ][ 'file' ][ 'name'     ];
	$file[ 'type'   ] =  $form[ '_FILES' ][ 'file' ][ 'type'     ];
	$file[ 'size'   ] =  $form[ '_FILES' ][ 'file' ][ 'size'     ];
	$file[ 'tmp'    ] =  $form[ '_FILES' ][ 'file' ][ 'tmp_name' ];
	$file[ 'source' ] =  '';
	$file[ 'width'  ] =  '';
	$file[ 'height' ] =  '';

	if( $error == 0 )                                                      {                 $message .= "\t\t".  'SUCCEEDED : 書き込みに成功しました.   <br /> '.  "\r\n";    return true;  }
	else                                                                   {                 $message .= "\t\t".  'FAILED    : 書き込みに失敗しました.   <br /> '.  "\r\n";    return false; }
}




// WHLX_PostingXML_NextID( $filename, $listtag, $ascending );
// // 
function  WHLX_PostingXML_NextID( $filename, $listtag, $ascending )
{
	$dom  =  xmldocfile( $filename );    

	// <whlx>     のノードを取得します. 
	if( $dom ->has_child_nodes() ) $buffer =  $dom ->child_nodes();
	foreach( $buffer as $node )                  if( 'whlx'   == $node->node_name() ){ $whlx =  $node; }

	// <$listtag> のノードを取得します. 
	if( $whlx->has_child_nodes() ) $buffer =  $whlx->child_nodes();
	foreach( $buffer as $node )                  if( $listtag == $node->node_name() ){ $list =  $node; }

	// <item>     のノードを取得します. 
	// 昇順降順 boolean $ascending が true  の場合は, 一番下の <item> を取得します. 
	// 昇順降順 boolean $ascending が false の場合は, 一番上の <item> を取得します. 
	if( $list->has_child_nodes() ) $buffer =  $list->child_nodes();
	else                           return '0001';
	if( $ascending ){ foreach( $buffer as $node ) if( 'item'   == $node->node_name() ){ $item =  $node; }         }
	else            { foreach( $buffer as $node ) if( 'item'   == $node->node_name() ){ $item =  $node;  break; } }
	if( $item == null ) return '0001';

	// <item> の中のアトリビュート 'id' を取得します. 
	$attrs =  $item->attributes ();    
	foreach( $attrs  as $attr )                  if( 'id'     == $attr->name()      ){ $last =  $attr->value(); }

	return  substr( ( '1'.  $last ) + 1, 1, 4 );
}




// WHLX_PostingXML_Create_NewArticle( $filename, $listtag, $ascending, $form );
// // 
function  WHLX_PostingXML_Create_NewArticle( $filename, $listtag, $ascending, $form )
{
	$dom       =  WHLX_DomXML_NewDocument  ( WHLX_XML_VERSION );    
	$pi        =  WHLX_DomXML_RegisterXSLT ( $dom, $form[ 'xslt' ], WHLX_XML_VERSION, 'text/xsl', 'UTF-8' );
	$whlx      =  WHLX_DomXML_CreateChild  ( $dom, $dom  , 'whlx     ', '' );    
	$items     =  WHLX_DomXML_CreateChild  ( $dom, $whlx , 'items    ', '' );    
	$item      =  WHLX_DomXML_CreateChild  ( $dom, $items, 'item     ', '' );    
	$title     =  WHLX_DomXML_CreateChild  ( $dom, $item , 'title    ', '' );    
	$url       =  WHLX_DomXML_CreateChild  ( $dom, $item , 'url      ', '' );    
	$text      =  WHLX_DomXML_CreateChild  ( $dom, $item , 'text     ', '' );    
	$creator   =  WHLX_DomXML_CreateChild  ( $dom, $item , 'creator  ', '' );    
	$date      =  WHLX_DomXML_CreateChild  ( $dom, $item , 'date     ', '' );    
	$trackback =  WHLX_DomXML_CreateChild  ( $dom, $item , 'trackback', '' );    

	$whlx->set_attribute( 'series'  , $form[ 'series'      ] );    
	$whlx->set_attribute( 'category', $form[ 'category'    ] );    
	$whlx->set_attribute( 'title'   , $form[ 'title_short' ] );    
	$item->set_attribute( 'id'      , $form[ 'new_id'      ] );    

	WHLX_DomXML_CreateComment  ( $dom, $title    , ' WHLX_PostingXML_Create_NewArticle title     ' );    
	WHLX_DomXML_CreateComment  ( $dom, $url      , ' WHLX_PostingXML_Create_NewArticle url       ' );    
	WHLX_DomXML_CreateComment  ( $dom, $text     , ' WHLX_PostingXML_Create_NewArticle text      ' );    
	WHLX_DomXML_CreateComment  ( $dom, $creator  , ' WHLX_PostingXML_Create_NewArticle creator   ' );    
	WHLX_DomXML_CreateComment  ( $dom, $date     , ' WHLX_PostingXML_Create_NewArticle date      ' );    
	WHLX_DomXML_CreateComment  ( $dom, $trackback, ' WHLX_PostingXML_Create_NewArticle trackback ' );    

	// DOMXML を文字列データ起こしします. 
	// さらにXMLデータに追加した <item>ノードにデータ文字列を入力します. 
	// この入力操作は, 先程入力したコメント・ノードを新しいデータに置換する事で賄います. 
	// 将来的には XMLタグのインデント操作も行う予定です(現在は改行コードの付加のみ行なっています). 
	$output =  $dom->dumpmem();
	$output =  str_replace( '<!-- WHLX_PostingXML_Create_NewArticle title     -->', $form[ 'title'     ], $output );
	$output =  str_replace( '<!-- WHLX_PostingXML_Create_NewArticle url       -->', $form[ 'url'       ], $output );
	$output =  str_replace( '<!-- WHLX_PostingXML_Create_NewArticle text      -->', $form[ 'text'      ], $output );
	$output =  str_replace( '<!-- WHLX_PostingXML_Create_NewArticle creator   -->', $form[ 'creator'   ], $output );
	$output =  str_replace( '<!-- WHLX_PostingXML_Create_NewArticle date      -->', $form[ 'date'      ], $output );
	$output =  str_replace( '<!-- WHLX_PostingXML_Create_NewArticle trackback -->', $form[ 'trackback' ], $output );
	$output =  str_replace( '><'                                                  , ">\r\n<"            , $output );
	return  $output;
}




// WHLX_PostingXML_InsertItem_Into_Article( $filename, $listtag, $ascending, $form );
// // 
function  WHLX_PostingXML_InsertItem_Into_Article( $filename, $listtag, $ascending, $form )
{
	$dom  =  xmldocfile( $filename );    

	// <whlx>     のノードを取得します. 
	if( $dom ->has_child_nodes() ) $buffer =  $dom ->child_nodes();
	foreach( $buffer as $node )                  if( 'whlx'   == $node->node_name() ){ $whlx =  $node; }

	// <items>    のノードを取得します. 
	if( $whlx->has_child_nodes() ) $buffer =  $whlx->child_nodes();
	foreach( $buffer as $node )                  if( $listtag == $node->node_name() ){ $list =  $node; }

	// <item>     のノードを取得します. 
	if( $list->has_child_nodes() ) $buffer =  $list->child_nodes();
	foreach( $buffer as $node )                  if( 'item'   == $node->node_name() ){ $item =  $node; }

	// 新しい <item>ノードを作ります. 
	// データ部分は最初はコメント・ノードとして書き込みます. 
	$item =  $dom->create_element( 'item' );
	$item->set_attribute( 'id', $form[ 'new_id' ] );    
	$title     =  WHLX_DomXML_CreateChild  ( $dom, $item, 'title  ', '' );    
	$url       =  WHLX_DomXML_CreateChild  ( $dom, $item, 'url    ', '' );    
	$excerpt   =  WHLX_DomXML_CreateChild  ( $dom, $item, 'excerpt', '' );    
	$blog_name =  WHLX_DomXML_CreateChild  ( $dom, $item, 'name   ', '' );    
	$date      =  WHLX_DomXML_CreateChild  ( $dom, $item, 'date   ', '' );    
	WHLX_DomXML_CreateComment  ( $dom, $title    , ' WHLX_PostingXML_InsertItem_Into_Article title     ' );    
	WHLX_DomXML_CreateComment  ( $dom, $url      , ' WHLX_PostingXML_InsertItem_Into_Article url       ' );    
	WHLX_DomXML_CreateComment  ( $dom, $excerpt  , ' WHLX_PostingXML_InsertItem_Into_Article excerpt   ' );    
	WHLX_DomXML_CreateComment  ( $dom, $blog_name, ' WHLX_PostingXML_InsertItem_Into_Article blog_name ' );    
	WHLX_DomXML_CreateComment  ( $dom, $date     , ' WHLX_PostingXML_InsertItem_Into_Article date      ' );    

	// 新しく作った <item>ノードをXMLデータに追加します. 
	// 既存の<item>が一つも無い時は,   単純に追加します. 
	// 既存の<item>が一つでも有る時は, 昇順降順 boolean $ascending を元に判断します. 
	// 昇順降順 boolean $ascending が true  の場合は, 単純に追加します. 
	// 昇順降順 boolean $ascending が false の場合は, 先頭のアイテムの上に追加します. 
	if( $list->has_child_nodes() ) 
	{
		if( $ascending ) $list->add_child    ( $item );
		else             $list->insert_before( $item, $list->first_child() );
	}
	else                     $list->add_child    ( $item );

	// DOMXML を文字列データ起こしします. 
	// さらにXMLデータに追加した <item>ノードにデータ文字列を入力します. 
	// この入力操作は, 先程入力したコメント・ノードを新しいデータに置換する事で賄います. 
	// 将来的には XMLタグのインデント操作も行う予定です(現在は改行コードの付加のみ行なっています). 
	$output =  $dom->dumpmem();
	$output =  str_replace( '<!-- WHLX_PostingXML_InsertItem_Into_Article title     -->', $form[ 'title'     ], $output );
	$output =  str_replace( '<!-- WHLX_PostingXML_InsertItem_Into_Article url       -->', $form[ 'url'       ], $output );
	$output =  str_replace( '<!-- WHLX_PostingXML_InsertItem_Into_Article excerpt   -->', $form[ 'excerpt'   ], $output );
	$output =  str_replace( '<!-- WHLX_PostingXML_InsertItem_Into_Article blog_name -->', $form[ 'blog_name' ], $output );
	$output =  str_replace( '<!-- WHLX_PostingXML_InsertItem_Into_Article date      -->', $form[ 'date'      ], $output );
	$output =  str_replace( '><'                                                        , ">\r\n<"            , $output );
	return  $output;
}




// WHLX_PostingXML_InsertItem_Into_List   ( $filename, $listtag, $ascending, $form );
// // 
function  WHLX_PostingXML_InsertItem_Into_List   ( $filename, $listtag, $ascending, $form )
{
	$dom  =  xmldocfile( $filename );    

	// <whlx>     のノードを取得します. 
	if( $dom ->has_child_nodes() ) $buffer =  $dom ->child_nodes();
	foreach( $buffer as $node )                  if( 'whlx'   == $node->node_name() ){ $whlx =  $node; }

	// <$listtag> のノードを取得します. 
	if( $whlx->has_child_nodes() ) $buffer =  $whlx->child_nodes();
	foreach( $buffer as $node )                  if( $listtag == $node->node_name() ){ $list =  $node; }

	// 新しい <item>ノードを作ります. 
	// データ部分は最初はコメント・ノードとして書き込みます. 
	$item =  $dom->create_element( 'item' );
	$item->set_attribute( 'id'      , $form[ 'lst_id'       ] );    
	$item->set_attribute( 'resource', $form[ 'lst_resource' ] );    
	$item->set_attribute( 'title'   , $form[ 'title_short'  ] );    

	// 新しく作った <item>ノードをXMLデータに追加します. 
	// 既存の<item>が一つも無い時は,   単純に追加します. 
	// 既存の<item>が一つでも有る時は, 昇順降順 boolean $ascending を元に判断します. 
	// 昇順降順 boolean $ascending が true  の場合は, 単純に追加します. 
	// 昇順降順 boolean $ascending が false の場合は, 先頭のアイテムの上に追加します. 
	if( $list->has_child_nodes() ) 
	{
		if( $ascending ) $list->add_child    ( $item );
		else             $list->insert_before( $item, $list->first_child() );
	}
	else                     $list->add_child    ( $item );

	// DOMXML を文字列データ起こしします. 
	// 将来的には XMLタグのインデント操作も行う予定です(現在は改行コードの付加のみ行なっています). 
	$output =  $dom->dumpmem();
	$output =  str_replace( '><', ">\r\n<", $output );
	return  $output;
}




// WHLX_PostingXML_FormAttributes( $attribute );
// // XHTML の form タグのアトリビュートを生成するために使われる XML データを生成します. 
function  WHLX_PostingXML_FormAttributes( $attribute )
{
	$output =  '';
	$output .= "\t\t\t".  '<attribute> ' .  "\r\n";
	if( is_string( $attribute[ 'action'  ] ) ) $output .= "\t\t\t\t".  '<action >'.  $attribute[ 'action'  ].  '</action > '.  "\r\n";    
	if( is_string( $attribute[ 'method'  ] ) ) $output .= "\t\t\t\t".  '<method >'.  $attribute[ 'method'  ].  '</method > '.  "\r\n";    
	if( is_string( $attribute[ 'accept'  ] ) ) $output .= "\t\t\t\t".  '<accept >'.  $attribute[ 'accept'  ].  '</accept > '.  "\r\n";    
	if( is_string( $attribute[ 'charset' ] ) ) $output .= "\t\t\t\t".  '<charset>'.  $attribute[ 'charset' ].  '</charset> '.  "\r\n";    
	if( is_string( $attribute[ 'enctype' ] ) ) $output .= "\t\t\t\t".  '<enctype>'.  $attribute[ 'enctype' ].  '</enctype> '.  "\r\n";    
	if( is_string( $attribute[ 'lang'    ] ) ) $output .= "\t\t\t\t".  '<lang   >'.  $attribute[ 'lang'    ].  '</lang   > '.  "\r\n";    
	$output .= "\t\t\t".  '</attribute> '.  "\r\n";
	return  $output;
}




// WHLX_PostingXML_FormDataEntered( $form );
// // XHTML の form タグの子ノードを生成するために使われる XML データを生成します. 
function  WHLX_PostingXML_FormDataEntered( $form )
{
	$output =  '';
	if( is_string( $form[ 'title'     ] ) ) $output .= "\t\t\t".  '<title    >'.  $form[ 'title'     ].  '</title    > '.  "\r\n";    
	if( is_string( $form[ 'url'       ] ) ) $output .= "\t\t\t".  '<url      >'.  $form[ 'url'       ].  '</url      > '.  "\r\n";    
	if( is_string( $form[ 'text'      ] ) ) $output .= "\t\t\t".  '<text     >'.  $form[ 'text'      ].  '</text     > '.  "\r\n";    
	if( is_string( $form[ 'style_br'  ] ) ) $output .= "\t\t\t".  '<style_br >'.  $form[ 'style_br'  ].  '</style_br > '.  "\r\n";    
	if( is_string( $form[ 'style_tg'  ] ) ) $output .= "\t\t\t".  '<style_tg >'.  $form[ 'style_tg'  ].  '</style_tg > '.  "\r\n";    
	if( is_string( $form[ 'excerpt'   ] ) ) $output .= "\t\t\t".  '<excerpt  >'.  $form[ 'excerpt'   ].  '</excerpt  > '.  "\r\n";    
	if( is_string( $form[ 'ping'      ] ) ) $output .= "\t\t\t".  '<ping     >'.  $form[ 'ping'      ].  '</ping     > '.  "\r\n";    
	if( is_string( $form[ 'creator'   ] ) ) $output .= "\t\t\t".  '<creator  >'.  $form[ 'creator'   ].  '</creator  > '.  "\r\n";    
	if( is_string( $form[ 'blog_name' ] ) ) $output .= "\t\t\t".  '<blog_name>'.  $form[ 'blog_name' ].  '</blog_name> '.  "\r\n";    
//	if( is_string( $form[ 'date'      ] ) ) $output .= "\t\t\t".  '<date     >'.  $form[ 'date'      ].  '</date     > '.  "\r\n";    
	if( is_string( $form[ 'trackback' ] ) ) $output .= "\t\t\t".  '<trackback>'.  $form[ 'trackback' ].  '</trackback> '.  "\r\n";    
	if( is_string( $form[ 'category'  ] ) ) $output .= "\t\t\t".  '<category >'.  $form[ 'category'  ].  '</category > '.  "\r\n";    
	return  $output;
}




// WHLX_PostingXML_FormDataUploaded( $file );
// // XHTML の form タグの子ノードを生成するために使われる XML データを生成します. 
function  WHLX_PostingXML_FormDataUploaded( $file )
{
	$output =  '';
	$output .= "\t\t\t".  '<file> ' .  "\r\n";
	if( is_string( $file[ 'name'   ] ) ) $output .= "\t\t\t\t".  '<name  >'.  $file[ 'name'   ].  '</name  >'.  "\r\n";    
	if( is_string( $file[ 'type'   ] ) ) $output .= "\t\t\t\t".  '<type  >'.  $file[ 'type'   ].  '</type  >'.  "\r\n";    
	if( is_string( $file[ 'size'   ] ) ) $output .= "\t\t\t\t".  '<size  >'.  $file[ 'size'   ].  '</size  >'.  "\r\n";    
	if( is_string( $file[ 'tmp'    ] ) ) $output .= "\t\t\t\t".  '<tmp   >'.  $file[ 'tmp'    ].  '</tmp   >'.  "\r\n";    
	if( is_string( $file[ 'source' ] ) ) $output .= "\t\t\t\t".  '<source>'.  $file[ 'source' ].  '</source>'.  "\r\n";    
	if( is_string( $file[ 'width'  ] ) ) $output .= "\t\t\t\t".  '<width >'.  $file[ 'width'  ].  '</width >'.  "\r\n";    
	if( is_string( $file[ 'height' ] ) ) $output .= "\t\t\t\t".  '<height>'.  $file[ 'height' ].  '</height>'.  "\r\n";    
	if( is_string( $file[ 'mime'   ] ) ) $output .= "\t\t\t\t".  '<mime  >'.  $file[ 'mime'   ].  '</mime  >'.  "\r\n";    
	$output .= "\t\t\t".  '</file> '.  "\r\n";
	return  $output;
}




// WHLX_PostingXML_ResultPreview( $form );
// // 
function  WHLX_PostingXML_ResultPreview( $form )
{
	$output =  '';
	$output .= "\t\t".  '<result> <item> '  .  "\r\n";
	if( is_string( $form[ 'title'     ] ) ) $output .= "\t\t\t".  '<title    >'.  $form[ 'title'     ].  '</title    > '.  "\r\n";    
	if( is_string( $form[ 'url'       ] ) ) $output .= "\t\t\t".  '<url      >'.  $form[ 'url'       ].  '</url      > '.  "\r\n";    
	if( is_string( $form[ 'text'      ] ) ) $output .= "\t\t\t".  '<text     >'.  $form[ 'text'      ].  '</text     > '.  "\r\n";    
	if( is_string( $form[ 'style_br'  ] ) ) $output .= "\t\t\t".  '<style_br >'.  $form[ 'style_br'  ].  '</style_br > '.  "\r\n";    
	if( is_string( $form[ 'style_tg'  ] ) ) $output .= "\t\t\t".  '<style_tg >'.  $form[ 'style_tg'  ].  '</style_tg > '.  "\r\n";    
	if( is_string( $form[ 'excerpt'   ] ) ) $output .= "\t\t\t".  '<excerpt  >'.  $form[ 'excerpt'   ].  '</excerpt  > '.  "\r\n";    
	if( is_string( $form[ 'ping'      ] ) ) $output .= "\t\t\t".  '<ping     >'.  $form[ 'ping'      ].  '</ping     > '.  "\r\n";    
	if( is_string( $form[ 'creator'   ] ) ) $output .= "\t\t\t".  '<creator  >'.  $form[ 'creator'   ].  '</creator  > '.  "\r\n";    
	if( is_string( $form[ 'blog_name' ] ) ) $output .= "\t\t\t".  '<blog_name>'.  $form[ 'blog_name' ].  '</blog_name> '.  "\r\n";    
	if( is_string( $form[ 'date'      ] ) ) $output .= "\t\t\t".  '<date     >'.  $form[ 'date'      ].  '</date     > '.  "\r\n";    
	if( is_string( $form[ 'trackback' ] ) ) $output .= "\t\t\t".  '<trackback>'.  $form[ 'trackback' ].  '</trackback> '.  "\r\n";    
	if( is_string( $form[ 'category'  ] ) ) $output .= "\t\t\t".  '<category >'.  $form[ 'category'  ].  '</category > '.  "\r\n";    
	$output .= "\t\t".  '</item> </result> '.  "\r\n";
	return  $output;
}




?>
