#pragma once

#include "stdafx.h"
#include "SocketX.h"

//////////////////////////////////////////////////////////////////////////

IMPLEMENT_DYNAMIC(CRawSocket, CPeerSocket)

CRawSocket::CRawSocket() :
	m_fPromiscuous(FALSE)
{
}

CRawSocket::~CRawSocket()
{
}

BOOL CRawSocket::Initialize(SOCKMSG SockMsg, DWORD dwLocalAddress, WORD wPort)
{
	SOCKADDR_IN siAddr;

	if (!CreateSocket(SockMsg))
	{
		return FALSE;
	}

	if (!Bind(wPort, dwLocalAddress))
	{
		CloseSocket();
		return FALSE;
	}

	if (!(SetSendBufferSize(SX_UDP_BUFSIZE) && SetSendBufferSize(SX_UDP_BUFSIZE)))
	{
		CloseSocket();
		return FALSE;
	}

	siAddr.sin_family	   = AF_INET;
	siAddr.sin_port		   = htons(wPort);
	siAddr.sin_addr.s_addr = dwLocalAddress;
	CopyMemory(&m_LocalAddr, &siAddr, sizeof(m_LocalAddr));

	m_fInit = TRUE;

	return TRUE;
}

BOOL CRawSocket::CreateSocket(SOCKMSG SockMsg)
{
	if (!IBaseSocket::CreateSocketWindow())
	{
		return FALSE;
	}

	SetTargetWnd(SockMsg);

	m_hSocket = socket(AF_INET, SOCK_RAW, IPPROTO_IP);

	if (m_hSocket == INVALID_SOCKET)
	{
		TRACE1("***** ERROR: socket(%d) *****\n", GetLastError());
		m_dwError = GetLastError();
		return FALSE;
	}

	SetSendTimeout(m_dwSendTimeout);
	SetRecieveTimeout(m_dwReceiveTimeout);

	return TRUE;
}

BOOL CRawSocket::SetPromiscuous(BOOL flag)
{
	DWORD dwOption = flag ? 1 : 0;

	if (!IOCtlSocket(SIO_RCVALL, &dwOption))
	{
		return FALSE;
	}

	m_fPromiscuous = flag;

	return TRUE;
}


//////////////////////////////////////////////////////////////////////////