/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.section;

import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.Section;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.CheckPropertyDescriptor;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.DescriptorToolkit;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class CheckSection
extends Section {
    protected CheckPropertyDescriptor check;
    private int width = -1;
    private boolean fillCheck = false;
    IDescriptorProvider provider;

    public CheckSection(Composite parent, boolean isFormStyle) {
        super(" ", parent, isFormStyle);
    }

    public CheckSection(Composite parent, String title, boolean isFormStyle) {
        super(title, parent, isFormStyle);
    }

    public void createSection() {
        if (!this.getLabelText().trim().equals("")) {
            this.getLabelControl(this.parent);
        }
        this.getCheckControl(this.parent);
        this.getGridPlaceholder(this.parent);
    }

    protected CheckPropertyDescriptor getCheckControl(Composite parent) {
        if (this.check == null) {
            this.check = DescriptorToolkit.createCheckPropertyDescriptor(this.isFormStyle);
            this.check.setDescriptorProvider(this.getProvider());
            this.check.createControl(parent);
            this.check.getControl().setLayoutData((Object)new GridData());
            this.check.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    CheckSection.this.check = null;
                }
            });
        } else {
            this.checkParent(this.check.getControl(), parent);
        }
        return this.check;
    }

    public CheckPropertyDescriptor getCheckControl() {
        return this.check;
    }

    public void layout() {
        GridData gd = (GridData)this.check.getControl().getLayoutData();
        gd.horizontalSpan = this.getLayoutNum() > 0 ? this.getLayoutNum() - this.placeholder : ((GridLayout)this.parent.getLayout()).numColumns - this.placeholder;
        if (this.getLabelControl() != null) {
            --gd.horizontalSpan;
        }
        gd.horizontalAlignment = 4;
        if (this.width > -1) {
            gd.widthHint = this.width;
            gd.grabExcessHorizontalSpace = false;
        } else {
            gd.grabExcessHorizontalSpace = this.fillCheck;
        }
    }

    public void load() {
        if (this.check != null && !this.check.getControl().isDisposed()) {
            this.check.load();
        }
    }

    public void reset() {
        if (this.check != null && !this.check.getControl().isDisposed()) {
            this.check.reset();
        }
    }

    public void setInput(Object input) {
        assert (input != null);
        this.check.setInput(input);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public boolean isFillCheck() {
        return this.fillCheck;
    }

    public void setFillCheck(boolean fillCheck) {
        this.fillCheck = fillCheck;
    }

    public void setHidden(boolean isHidden) {
        if (this.displayLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.displayLabel, isHidden);
        }
        if (this.check != null) {
            this.check.setHidden(isHidden);
        }
        if (this.placeholderLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.placeholderLabel, isHidden);
        }
    }

    public void setVisible(boolean isVisible) {
        if (this.displayLabel != null) {
            this.displayLabel.setVisible(isVisible);
        }
        if (this.check != null) {
            this.check.setVisible(isVisible);
        }
        if (this.placeholderLabel != null) {
            this.placeholderLabel.setVisible(isVisible);
        }
    }

    public IDescriptorProvider getProvider() {
        return this.provider;
    }

    public void setProvider(IDescriptorProvider provider) {
        this.provider = provider;
    }
}

