/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.command;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.command.SelectionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.StyleBuilder;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.model.api.AbstractThemeHandle;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.command.StyleException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.ui.PlatformUI;

public class NewStyleHandler
extends SelectionHandler {
    private static final String STACK_MSG_ADD_STYLE = Messages.getString((String)"NewStyleHandler.transaction.label");
    private AbstractThemeHandle themeHandle;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        super.execute(event);
        boolean retBoolean = true;
        if (Policy.TRACING_ACTIONS) {
            System.out.println("Add Style rule action >> Run ...");
        }
        CommandStack stack = this.getActiveCommandStack();
        stack.startTrans(STACK_MSG_ADD_STYLE);
        IEvaluationContext context = (IEvaluationContext)event.getApplicationContext();
        Object obj = context.getVariable("NewStyleAction.ThemeHandleName");
        this.themeHandle = obj instanceof AbstractThemeHandle ? (AbstractThemeHandle)obj : null;
        ModuleHandle reportDesignHandle = SessionHandleAdapter.getInstance().getReportDesignHandle();
        SharedStyleHandle styleHandle = this.themeHandle != null ? DesignElementFactory.getInstance(reportDesignHandle).newStyle(this.themeHandle, null) : DesignElementFactory.getInstance(reportDesignHandle).newStyle(null);
        try {
            StyleBuilder dialog = new StyleBuilder(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (ReportElementHandle)styleHandle, this.themeHandle, StyleBuilder.DLG_TITLE_NEW);
            if (dialog.open() == 0) {
                if (this.themeHandle != null) {
                    this.themeHandle.getStyles().add((DesignElementHandle)styleHandle);
                } else {
                    reportDesignHandle.getStyles().add((DesignElementHandle)styleHandle);
                    if (!styleHandle.isPredefined()) {
                        this.applyStyle(styleHandle);
                    }
                }
                stack.commit();
            } else {
                stack.rollbackAll();
                retBoolean = false;
            }
        }
        catch (Exception e) {
            stack.rollbackAll();
            ExceptionHandler.handle(e);
            retBoolean = false;
        }
        return retBoolean;
    }

    private void applyStyle(SharedStyleHandle styleHandle) {
        List elements = this.getElementHandles();
        List handles = new ArrayList();
        handles = elements;
        int i = 0;
        while (i < handles.size()) {
            try {
                if (handles.get(i) instanceof ReportElementHandle) {
                    ((DesignElementHandle)handles.get(i)).setStyle(styleHandle);
                }
            }
            catch (StyleException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
            }
            ++i;
        }
    }
}

