/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.util;

import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.ExpressionButton;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.IExpressionHelper;
import org.eclipse.birt.report.designer.internal.ui.expressions.ExpressionContextFactoryImpl;
import org.eclipse.birt.report.designer.internal.ui.expressions.IExpressionContextFactory;
import org.eclipse.birt.report.designer.internal.ui.expressions.IExpressionConverter;
import org.eclipse.birt.report.designer.internal.ui.expressions.IExpressionSupport;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExpressionHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class ExpressionButtonUtil {
    public static final String EXPR_BUTTON = "exprButton";
    public static final String EXPR_TYPE = "exprType";

    public static ExpressionButton createExpressionButton(Composite parent, Control control, IExpressionProvider provider, Object contextObject) {
        return ExpressionButtonUtil.createExpressionButton(parent, control, provider, contextObject, null, false, 8, new ExpressionHelper());
    }

    public static ExpressionButton createExpressionButton(Composite parent, Control control, IExpressionProvider provider, Object contextObject, ExpressionHelper helper) {
        return ExpressionButtonUtil.createExpressionButton(parent, control, provider, contextObject, null, false, 8, helper);
    }

    public static ExpressionButton createExpressionButton(Composite parent, Control control, IExpressionProvider provider, Object contextObject, Listener listener) {
        return ExpressionButtonUtil.createExpressionButton(parent, control, provider, contextObject, listener, false, 8, new ExpressionHelper());
    }

    public static ExpressionButton createExpressionButton(Composite parent, Control control, IExpressionProvider provider, Object contextObject, int style) {
        return ExpressionButtonUtil.createExpressionButton(parent, control, provider, contextObject, null, false, style, new ExpressionHelper());
    }

    public static ExpressionButton createExpressionButton(Composite parent, Control control, IExpressionProvider provider, Object contextObject, boolean allowConstant, int style) {
        return ExpressionButtonUtil.createExpressionButton(parent, control, provider, contextObject, null, allowConstant, style, new ExpressionHelper());
    }

    public static ExpressionButton createExpressionButton(Composite parent, Control control, IExpressionProvider provider, Object contextObject, Listener listener, boolean allowConstant, int style) {
        return ExpressionButtonUtil.createExpressionButton(parent, control, provider, contextObject, listener, allowConstant, style, new ExpressionHelper());
    }

    public static ExpressionButton createExpressionButton(Composite parent, Control control, IExpressionProvider provider, Object contextObject, Listener listener, boolean allowConstant, int style, ExpressionHelper helper) {
        ExpressionButton button = UIUtil.createExpressionButton(parent, style, allowConstant);
        helper.setProvider(provider);
        helper.setListener(listener);
        helper.setControl(control);
        helper.setExpressionButton(button);
        helper.setContextObject(contextObject);
        button.setExpressionHelper(helper);
        control.setData(EXPR_BUTTON, (Object)button);
        control.setData(EXPR_TYPE, (Object)helper.getExpressionType());
        button.refresh();
        return button;
    }

    public static boolean isSupportJavaScript(ExpressionButton button) {
        return button.isSupportType("javascript");
    }

    public static void initExpressionButtonControl(Control control, Object element, String property) {
        if (element instanceof DesignElementHandle) {
            ExpressionHandle value = ((DesignElementHandle)element).getExpressionProperty(property);
            ExpressionButtonUtil.initExpressionButtonControl(control, value);
        } else if (element instanceof StructureHandle) {
            ExpressionHandle value = ((StructureHandle)element).getExpressionProperty(property);
            ExpressionButtonUtil.initExpressionButtonControl(control, value);
        } else if (element instanceof Structure) {
            Expression value = ((Structure)element).getExpressionProperty(property);
            ExpressionButtonUtil.initExpressionButtonControl(control, value);
        }
    }

    public static void saveExpressionButtonControl(Control control, Object element, String property) throws SemanticException {
        ExpressionButton button = ExpressionButtonUtil.getExpressionButton(control);
        if (button != null && button.getExpressionHelper() != null) {
            Expression expression = new Expression((Object)button.getExpressionHelper().getExpression(), button.getExpressionHelper().getExpressionType());
            if (element instanceof DesignElementHandle) {
                ((DesignElementHandle)element).setExpressionProperty(property, expression);
            } else if (element instanceof StructureHandle) {
                ((StructureHandle)element).setExpressionProperty(property, expression);
            } else if (element instanceof Structure) {
                ((Structure)element).setExpressionProperty(property, expression);
            }
        }
    }

    public static void initExpressionButtonControl(Control control, ExpressionHandle value) {
        ExpressionButton button = ExpressionButtonUtil.getExpressionButton(control);
        if (button != null && button.getExpressionHelper() != null) {
            button.getExpressionHelper().setExpressionType(value == null || value.getType() == null ? UIUtil.getDefaultScriptType() : value.getType());
            String stringValue = value == null || value.getExpression() == null ? "" : (String)value.getExpression();
            button.getExpressionHelper().setExpression(stringValue);
            button.refresh();
        }
    }

    public static void initExpressionButtonControl(Control control, Expression value) {
        ExpressionButton button = ExpressionButtonUtil.getExpressionButton(control);
        if (button != null && button.getExpressionHelper() != null) {
            button.getExpressionHelper().setExpressionType(value == null || value.getType() == null ? UIUtil.getDefaultScriptType() : value.getType());
            String stringValue = value == null || value.getExpression() == null ? "" : (String)value.getExpression();
            button.getExpressionHelper().setExpression(stringValue);
            button.refresh();
        }
    }

    public static Expression getExpression(Control control) {
        ExpressionButton button = ExpressionButtonUtil.getExpressionButton(control);
        if (button != null && button.getExpressionHelper() != null) {
            String expression = button.getExpressionHelper().getExpression();
            String type = button.getExpressionHelper().getExpressionType();
            return new Expression((Object)expression, type);
        }
        return null;
    }

    public static ExpressionButton getExpressionButton(Control control) {
        Object button = control.getData(EXPR_BUTTON);
        if (button instanceof ExpressionButton) {
            return (ExpressionButton)button;
        }
        return null;
    }

    public static IExpressionConverter getCurrentExpressionConverter(Control control) {
        return ExpressionButtonUtil.getCurrentExpressionConverter(control, true);
    }

    public static IExpressionConverter getCurrentExpressionConverter(Control control, boolean refreshButtonType) {
        if (control == null) {
            return null;
        }
        if (ExpressionButtonUtil.getExpressionButton(control) == null) {
            return null;
        }
        IExpressionSupport support = ExpressionButtonUtil.getExpressionButton(control).getCurrentExpressionSupport();
        if (support != null && support.getConverter() != null) {
            return support.getConverter();
        }
        if (refreshButtonType && (support = ExpressionButtonUtil.getExpressionButton(control).getExpressionSupport("javascript")) != null && support.getConverter() != null) {
            control.setData(EXPR_TYPE, (Object)"javascript");
            ExpressionButtonUtil.getExpressionButton(control).refresh();
            return support.getConverter();
        }
        return null;
    }

    public static class ExpressionHelper
    implements IExpressionHelper {
        protected Control control;
        protected Listener listener;
        private IExpressionProvider provider;
        protected ExpressionButton button;
        private Object contextObject;

        public String getExpression() {
            if (this.control.isDisposed()) {
                return "";
            }
            if (this.control instanceof Text) {
                return ((Text)this.control).getText();
            }
            if (this.control instanceof Combo) {
                return ((Combo)this.control).getText();
            }
            if (this.control instanceof CCombo) {
                return ((CCombo)this.control).getText();
            }
            return "";
        }

        public void notifyExpressionChangeEvent(String oldExpression, String newExpression) {
            if (this.listener != null) {
                Event event = new Event();
                event.widget = this.button.getControl();
                event.data = new String[]{oldExpression, newExpression};
                event.detail = 24;
                this.listener.handleEvent(event);
            }
            this.control.setFocus();
        }

        public void setExpression(String expression) {
            if (this.control.isDisposed()) {
                return;
            }
            if (this.control instanceof Text) {
                ((Text)this.control).setText(DEUtil.resolveNull((String)expression));
            } else if (this.control instanceof Combo) {
                ((Combo)this.control).setText(DEUtil.resolveNull((String)expression));
            } else if (this.control instanceof CCombo) {
                ((CCombo)this.control).setText(DEUtil.resolveNull((String)expression));
            }
        }

        public String getExpressionType() {
            if (!this.control.isDisposed()) {
                return (String)this.control.getData(ExpressionButtonUtil.EXPR_TYPE);
            }
            return UIUtil.getDefaultScriptType();
        }

        public void setExpressionType(String exprType) {
            if (!this.control.isDisposed()) {
                this.control.setData(ExpressionButtonUtil.EXPR_TYPE, (Object)exprType);
            }
        }

        protected void setProvider(IExpressionProvider provider) {
            this.provider = provider;
        }

        protected IExpressionProvider getProvider() {
            return this.provider;
        }

        protected void setListener(Listener listener) {
            this.listener = listener;
        }

        private void setControl(Control control) {
            this.control = control;
        }

        protected void setExpressionButton(ExpressionButton button) {
            this.button = button;
        }

        public Object getContextObject() {
            return this.contextObject;
        }

        protected void setContextObject(Object contextObject) {
            this.contextObject = contextObject;
        }

        public IExpressionContextFactory getExpressionContextFactory() {
            return new ExpressionContextFactoryImpl(this.contextObject, this.provider);
        }
    }
}

