/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.actions;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.actions.AbstractViewAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.UseCssInReportDialog;
import org.eclipse.birt.report.designer.ui.dialogs.UseCssInThemeDialog;
import org.eclipse.birt.report.model.api.AbstractThemeHandle;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.IncludedCssStyleSheetHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.model.api.elements.structures.IncludedCssStyleSheet;

public class EditUseCssStyleAction
extends AbstractViewAction {
    public static final String ID = "org.eclipse.birt.report.designer.internal.ui.views.EditUseCssStyleAction";
    public static final String ACTION_TEXT = Messages.getString((String)"EditUseCssStyleAction.text");

    public EditUseCssStyleAction(Object selectedObject) {
        this(selectedObject, ACTION_TEXT);
    }

    public EditUseCssStyleAction(Object selectedObject, String text) {
        super(selectedObject, text);
    }

    public boolean isEnabled() {
        Object selection = this.getSelection();
        if (selection == null) {
            return false;
        }
        return selection instanceof CssStyleSheetHandle;
    }

    public void run() {
        Object selection = this.getSelection();
        assert (selection instanceof CssStyleSheetHandle);
        CssStyleSheetHandle cssStyle = (CssStyleSheetHandle)selection;
        DesignElementHandle container = cssStyle.getContainerHandle();
        if (container instanceof ReportDesignHandle) {
            this.editCssInReportDesign(cssStyle, (ReportDesignHandle)container);
        } else if (container instanceof AbstractThemeHandle) {
            this.editCssInTheme(cssStyle, (AbstractThemeHandle)container);
        }
    }

    private void editCssInTheme(CssStyleSheetHandle cssStyle, AbstractThemeHandle theme) {
        UseCssInThemeDialog dialog = new UseCssInThemeDialog();
        dialog.setDialogTitle(Messages.getString((String)"EditUseCssStyleAction.EditCssTitle"));
        dialog.setTitle(Messages.getString((String)"EditUseCssStyleAction.EditCssAreaTitle.Libary"));
        String relativeFileName = cssStyle.getFileName();
        IncludedCssStyleSheetHandle includedCss = theme.findIncludedCssStyleSheetHandleByName(relativeFileName);
        dialog.setIncludedCssStyleSheetHandle(includedCss);
        dialog.setTheme(theme);
        if (dialog.open() == 0) {
            CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
            stack.startTrans(ACTION_TEXT);
            AbstractThemeHandle themeHandle = dialog.getTheme();
            if (themeHandle == theme) {
                try {
                    includedCss.setExternalCssURI(dialog.getURI());
                    themeHandle.renameCss(includedCss, dialog.getFileName());
                }
                catch (SemanticException e) {
                    ExceptionHandler.handle(e);
                    stack.rollback();
                    return;
                }
            }
            try {
                theme.dropCss(cssStyle);
                IncludedCssStyleSheet css = StructureFactory.createIncludedCssStyleSheet();
                css.setFileName(dialog.getFileName());
                css.setExternalCssURI(dialog.getURI());
                themeHandle.addCss(css);
            }
            catch (SemanticException e) {
                e.printStackTrace();
                stack.rollback();
                return;
            }
            stack.commit();
        }
    }

    private void editCssInReportDesign(CssStyleSheetHandle cssStyle, ReportDesignHandle reportDesign) {
        UseCssInReportDialog dialog = new UseCssInReportDialog();
        dialog.setDialogTitle(Messages.getString((String)"EditUseCssStyleAction.EditCssTitle"));
        dialog.setTitle(Messages.getString((String)"EditUseCssStyleAction.EditCssAreaTitle.Report"));
        String relativeFileName = cssStyle.getFileName();
        IncludedCssStyleSheetHandle includedCss = reportDesign.findIncludedCssStyleSheetHandleByFileName(relativeFileName);
        dialog.setIncludedCssStyleSheetHandle(includedCss);
        if (dialog.open() == 0) {
            CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
            stack.startTrans(ACTION_TEXT);
            try {
                includedCss.setExternalCssURI(dialog.getURI());
                reportDesign.renameCss(includedCss, dialog.getFileName());
            }
            catch (SemanticException e) {
                ExceptionHandler.handle(e);
                stack.rollback();
                return;
            }
            stack.commit();
        }
    }
}

