/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.actions;

import java.lang.reflect.Field;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.ContextSelectionAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportElementEditPart;
import org.eclipse.birt.report.designer.internal.ui.views.actions.CopyFormatAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.elements.interfaces.IStyleModel;
import org.eclipse.ui.IWorkbenchPart;

public class PasteFormatAction
extends ContextSelectionAction {
    public static final String ID = "org.eclipse.birt.report.designer.internal.ui.views.actions.PasteFormatAction";
    public static final String ACTION_TEXT = Messages.getString((String)"PasteFormatAction.text");

    public PasteFormatAction(IWorkbenchPart part) {
        super(part);
        this.setId(ID);
        this.setText(ACTION_TEXT);
        this.setImageDescriptor(ReportPlatformUIImages.getImageDescriptor("PasteFormat"));
    }

    protected boolean calculateEnabled() {
        return this.getSelectedObjects().size() == 1 && CopyFormatAction.getDesignElementHandle() != null;
    }

    public void run() {
        DesignElementHandle sourceElement = CopyFormatAction.getDesignElementHandle();
        if (sourceElement != null) {
            StyleHandle sourceStyle = sourceElement.getPrivateStyle();
            DesignElementHandle element = this.getSelectedElement();
            if (element != null) {
                element.getModuleHandle().getCommandStack().startTrans(ACTION_TEXT);
                Field[] fields = IStyleModel.class.getFields();
                int i = 0;
                while (i < fields.length) {
                    if ((fields[i].getModifiers() & 8) != 0 && (fields[i].getModifiers() & 0x10) != 0) {
                        try {
                            String propertyName = (String)fields[i].get(IStyleModel.class);
                            if (sourceStyle.getProperty(propertyName) != null) {
                                element.setProperty(propertyName, sourceStyle.getProperty(propertyName));
                            }
                        }
                        catch (Exception exception) {}
                    }
                    ++i;
                }
                element.getModuleHandle().getCommandStack().commit();
            }
        }
    }

    private DesignElementHandle getSelectedElement() {
        Object object = this.getSelectedObjects().get(0);
        if (object instanceof ReportElementEditPart) {
            return (DesignElementHandle)((ReportElementEditPart)((Object)object)).getModel();
        }
        return null;
    }
}

