/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.birt.report.model.adapter.oda.impl.AbstractDataAdapter;
import org.eclipse.birt.report.model.adapter.oda.impl.AdapterUtil;
import org.eclipse.birt.report.model.adapter.oda.impl.DataSetParameterAdapter;
import org.eclipse.birt.report.model.adapter.oda.impl.DataSourceAdapter;
import org.eclipse.birt.report.model.adapter.oda.impl.DesignerStateAdapter;
import org.eclipse.birt.report.model.adapter.oda.impl.ResultSetCriteriaAdapter;
import org.eclipse.birt.report.model.adapter.oda.impl.ResultSetsAdapter;
import org.eclipse.birt.report.model.adapter.oda.model.DataSetParameter;
import org.eclipse.birt.report.model.adapter.oda.model.DataSetParameters;
import org.eclipse.birt.report.model.adapter.oda.model.DesignValues;
import org.eclipse.birt.report.model.adapter.oda.model.DynamicList;
import org.eclipse.birt.report.model.adapter.oda.model.ModelFactory;
import org.eclipse.birt.report.model.adapter.oda.model.util.SchemaConversionUtil;
import org.eclipse.birt.report.model.adapter.oda.model.util.SerializerImpl;
import org.eclipse.birt.report.model.adapter.oda.util.IdentifierUtility;
import org.eclipse.birt.report.model.api.ColumnHintHandle;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.ColumnHint;
import org.eclipse.birt.report.model.api.elements.structures.OdaResultSetColumn;
import org.eclipse.birt.report.model.api.util.PropertyValueValidationUtil;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignSessionRequest;
import org.eclipse.datatools.connectivity.oda.design.DynamicValuesQuery;
import org.eclipse.datatools.connectivity.oda.design.InputElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.InputParameterAttributes;
import org.eclipse.datatools.connectivity.oda.design.OdaDesignSession;
import org.eclipse.datatools.connectivity.oda.design.ParameterDefinition;
import org.eclipse.datatools.connectivity.oda.design.Properties;
import org.eclipse.datatools.connectivity.oda.design.Property;
import org.eclipse.datatools.connectivity.oda.design.ResultSetDefinition;
import org.eclipse.datatools.connectivity.oda.design.ResultSets;
import org.eclipse.datatools.connectivity.oda.design.util.DesignUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataSetAdapter
extends AbstractDataAdapter {
    private String defaultDataSourceName = null;
    private boolean isLinkedParameter = false;

    DataSetAdapter() {
    }

    DataSetAdapter(DataSourceHandle defaultDataSource) {
        if (defaultDataSource != null) {
            this.defaultDataSourceName = defaultDataSource.getName();
            this.isLinkedParameter = true;
        }
    }

    DataSetDesign createDataSetDesign(OdaDataSetHandle setHandle) {
        if (setHandle == null) {
            return null;
        }
        DataSetDesign setDesign = this.designFactory.createDataSetDesign();
        this.updateDataSetDesign(setHandle, setDesign);
        return setDesign;
    }

    void updateDataSetDesign(OdaDataSetHandle setHandle, DataSetDesign setDesign) {
        setDesign.setName(setHandle.getName());
        String displayName = setHandle.getDisplayName();
        String displayNameKey = setHandle.getDisplayNameKey();
        if (displayName != null || displayNameKey != null) {
            setDesign.setDisplayName(displayName);
            setDesign.setDisplayNameKey(displayNameKey);
        }
        setDesign.setOdaExtensionDataSetId(setHandle.getExtensionID());
        setDesign.setPublicProperties(this.newOdaPublicProperties(setHandle.getExtensionPropertyDefinitionList(), (ReportElementHandle)setHandle));
        setDesign.setPrivateProperties(this.newOdaPrivateProperties(setHandle.privateDriverPropertiesIterator()));
        setDesign.setPrimaryResultSetName(setHandle.getResultSetName());
        setDesign.setQueryText(setHandle.getQueryText());
        OdaDataSourceHandle sourceHandle = (OdaDataSourceHandle)setHandle.getDataSource();
        if (sourceHandle != null) {
            setDesign.setDataSourceDesign(new DataSourceAdapter().createDataSourceDesign(sourceHandle));
        }
        String strDesignValues = setHandle.getDesignerValues();
        DesignValues designerValues = null;
        try {
            if (strDesignValues != null) {
                designerValues = SerializerImpl.instance().read(strDesignValues);
            }
        }
        catch (IOException iOException) {}
        DataSetParameters cachedParams = null;
        if (designerValues != null) {
            cachedParams = designerValues.getDataSetParameters();
        }
        DataSetParameterAdapter dataParamAdapter = new DataSetParameterAdapter(setHandle, setDesign);
        org.eclipse.datatools.connectivity.oda.design.DataSetParameters designDefinedParams = null;
        if (cachedParams != null) {
            designDefinedParams = SchemaConversionUtil.convertToDesignParameters((DataSetParameters)EcoreUtil.copy((EObject)cachedParams));
            setDesign.setParameters(designDefinedParams);
            dataParamAdapter.updateDriverDefinedParameter(designDefinedParams, SchemaConversionUtil.getCachedDynamicList(cachedParams));
        }
        if (designDefinedParams == null) {
            designDefinedParams = dataParamAdapter.newOdaDataSetParams(designDefinedParams);
            setDesign.setParameters(designDefinedParams);
        }
        dataParamAdapter.updateUserDefinedParameter(designDefinedParams);
        org.eclipse.datatools.connectivity.oda.design.DataSetParameters userDefinedParams = dataParamAdapter.newOdaDataSetParams(dataParamAdapter.getUserDefinedParams());
        if (designDefinedParams == null) {
            designDefinedParams = userDefinedParams;
            setDesign.setParameters(designDefinedParams);
        } else if (userDefinedParams != null) {
            designDefinedParams.getParameterDefinitions().addAll((Collection)userDefinedParams.getParameterDefinitions());
        }
        new ResultSetsAdapter(setHandle, setDesign).updateOdaResultSetDefinition();
        this.updateODAMessageFile(setDesign.getDataSourceDesign(), setHandle.getModuleHandle());
    }

    void updateDataSetDesign(OdaDataSetHandle setHandle, DataSetDesign setDesign, String propertyName) {
        if (setHandle == null || setDesign == null || propertyName == null) {
            return;
        }
        if ("name".equalsIgnoreCase(propertyName)) {
            setDesign.setName(setHandle.getName());
        } else if ("displayName".equalsIgnoreCase(propertyName)) {
            setDesign.setDisplayName(setHandle.getDisplayName());
        } else if ("displayNameID".equalsIgnoreCase(propertyName)) {
            setDesign.setDisplayNameKey(setHandle.getDisplayNameKey());
        } else if ("extensionID".equalsIgnoreCase(propertyName)) {
            setDesign.setOdaExtensionDataSetId(setHandle.getExtensionID());
        } else if ("privateDriverProperties".equalsIgnoreCase(propertyName)) {
            setDesign.setPrivateProperties(this.newOdaPrivateProperties(setHandle.privateDriverPropertiesIterator()));
        } else if ("resultSetName".equalsIgnoreCase(propertyName)) {
            setDesign.setPrimaryResultSetName(setHandle.getResultSetName());
        } else if ("queryText".equalsIgnoreCase(propertyName)) {
            setDesign.setQueryText(setHandle.getQueryText());
        } else if ("dataSource".equalsIgnoreCase(propertyName)) {
            OdaDataSourceHandle sourceHandle = (OdaDataSourceHandle)setHandle.getDataSource();
            if (sourceHandle != null) {
                setDesign.setDataSourceDesign(new DataSourceAdapter().createDataSourceDesign(sourceHandle));
            }
        } else if ("parameters".equalsIgnoreCase(propertyName)) {
            org.eclipse.datatools.connectivity.oda.design.DataSetParameters dsParams = new DataSetParameterAdapter(setHandle, setDesign).newOdaDataSetParams(SchemaConversionUtil.convertToDesignParameters(this.getCachedParameters(setHandle)));
            if (dsParams != null) {
                setDesign.setParameters(dsParams);
            } else {
                setDesign.setParameters(null);
            }
        } else if ("resultSet".equalsIgnoreCase(propertyName)) {
            new ResultSetsAdapter(setHandle, setDesign).updateOdaResultSetDefinition();
        } else if ("columnHints".equalsIgnoreCase(propertyName)) {
            new ResultSetsAdapter(setHandle, setDesign).updateOdaColumnHints();
        } else if ("filter".equalsIgnoreCase(propertyName)) {
            new ResultSetCriteriaAdapter(setHandle, setDesign).updateODAResultSetCriteria();
        }
        this.updateODAMessageFile(setDesign.getDataSourceDesign(), setHandle.getModuleHandle());
    }

    private DataSetParameters getCachedParameters(OdaDataSetHandle setHandle) {
        String strDesignValues = setHandle.getDesignerValues();
        DesignValues designerValues = null;
        try {
            if (strDesignValues != null) {
                designerValues = SerializerImpl.instance().read(strDesignValues);
            }
        }
        catch (IOException iOException) {}
        DataSetParameters cachedParams = null;
        if (designerValues != null) {
            cachedParams = designerValues.getDataSetParameters();
        }
        return cachedParams;
    }

    public OdaDesignSession createOdaDesignSession(OdaDataSetHandle dataSetHandle) {
        OdaDesignSession session = this.designFactory.createOdaDesignSession();
        DataSetDesign setDesign = this.createDataSetDesign(dataSetHandle);
        DesignSessionRequest request = this.designFactory.createDesignSessionRequest();
        request.setNewDataAccessDesign(setDesign);
        request.setDesignerState(DesignerStateAdapter.createOdaDesignState(dataSetHandle.getDesignerState()));
        session.setRequest(request);
        return session;
    }

    OdaDataSetHandle createDataSetHandle(DataSetDesign setDesign, ModuleHandle module) throws SemanticException, IllegalStateException {
        if (setDesign == null) {
            return null;
        }
        DesignUtil.validateObject((EObject)setDesign);
        OdaDataSetHandle setHandle = module.getElementFactory().newOdaDataSet(setDesign.getName(), setDesign.getOdaExtensionDataSetId());
        if (setHandle == null) {
            return null;
        }
        this.adaptDataSetDesign(setDesign, setHandle);
        return setHandle;
    }

    public void updateDataSetHandle(DataSetDesign setDesign, OdaDataSetHandle setHandle, boolean isSourceChanged) throws SemanticException {
        if (setDesign == null || setHandle == null) {
            return;
        }
        DesignValues designerValues = null;
        try {
            designerValues = SerializerImpl.instance().read(setHandle.getDesignerValues());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DataSetParameters requestParameters = null;
        ResultSets requestResultSets = null;
        if (designerValues != null) {
            requestParameters = designerValues.getDataSetParameters();
            requestResultSets = designerValues.getResultSets();
        }
        this.updateDataSetHandle(setDesign, setHandle, isSourceChanged, requestParameters, requestResultSets);
    }

    public void updateDataSetHandle(OdaDataSetHandle dataSetHandle, OdaDesignSession completedSession) throws SemanticException {
        if (completedSession == null || dataSetHandle == null) {
            return;
        }
        DataSetDesign responseDesign = completedSession.getResponseDataSetDesign();
        DataSetDesign requestDesign = completedSession.getRequestDataSetDesign();
        this.updateDataSetHandle(responseDesign, dataSetHandle, false, SchemaConversionUtil.convertToAdapterParameters(requestDesign.getParameters()), requestDesign.getResultSets());
        DesignerStateAdapter.updateROMDesignerState(completedSession.getResponse().getDesignerState(), (ReportElementHandle)dataSetHandle);
    }

    private void adaptDataSetDesign(DataSetDesign setDesign, OdaDataSetHandle setHandle) throws SemanticException {
        Object value = null;
        value = setDesign.getName();
        PropertyValueValidationUtil.validateProperty((DesignElementHandle)setHandle, (String)"name", (Object)value);
        setHandle.getElement().setName(setDesign.getName());
        value = setDesign.getDisplayName();
        PropertyValueValidationUtil.validateProperty((DesignElementHandle)setHandle, (String)"displayName", (Object)value);
        setHandle.getElement().setProperty("displayName", value);
        value = setDesign.getDisplayNameKey();
        PropertyValueValidationUtil.validateProperty((DesignElementHandle)setHandle, (String)"displayNameID", (Object)value);
        setHandle.getElement().setProperty("displayNameID", value);
        value = this.newROMPrivateProperties(setDesign.getPrivateProperties());
        PropertyValueValidationUtil.validateProperty((DesignElementHandle)setHandle, (String)"privateDriverProperties", (Object)value);
        setHandle.getElement().setProperty("privateDriverProperties", value);
        this.updateROMPublicProperties(setDesign.getPublicProperties(), (ReportElementHandle)setHandle);
        DataSourceDesign sourceDesign = setDesign.getDataSourceDesign();
        String dataSourceName = null;
        if (sourceDesign != null) {
            dataSourceName = sourceDesign.getName();
            ModuleHandle moduleHandle = setHandle.getModuleHandle();
            DataSourceHandle sourceHandle = null;
            if (this.isLinkedParameter) {
                sourceHandle = moduleHandle.getElementFactory().newOdaDataSource(dataSourceName, sourceDesign.getOdaExtensionDataSourceId());
                moduleHandle.getDataSources().add((DesignElementHandle)sourceHandle);
            } else {
                sourceHandle = moduleHandle.findDataSource(dataSourceName);
            }
            if (sourceHandle != null && sourceHandle instanceof OdaDataSourceHandle) {
                new DataSourceAdapter().updateDataSourceHandle(sourceDesign, (OdaDataSourceHandle)sourceHandle);
                dataSourceName = sourceHandle.getName();
            }
        } else {
            dataSourceName = this.defaultDataSourceName;
        }
        setHandle.getElement().setProperty("dataSource", PropertyValueValidationUtil.validateProperty((DesignElementHandle)setHandle, (String)"dataSource", (Object)dataSourceName));
        setHandle.getElement().clearProperty("parameters");
        List dataSetParams = new DataSetParameterAdapter(setHandle, setDesign).newROMSetParams(null);
        PropertyValueValidationUtil.validateProperty((DesignElementHandle)setHandle, (String)"parameters", (Object)dataSetParams);
        setHandle.getElement().setProperty("parameters", (Object)dataSetParams);
        ResultSetsAdapter tmpAdapter = new ResultSetsAdapter(setHandle, setDesign);
        List<ResultSetsAdapter.ResultSetColumnInfo> resultRetColumns = tmpAdapter.newROMResultSets(null);
        tmpAdapter.updateROMFilterCondition();
        ArrayList<OdaResultSetColumn> columns = null;
        ArrayList<ColumnHint> hints = null;
        if (resultRetColumns != null) {
            columns = new ArrayList<OdaResultSetColumn>();
            hints = new ArrayList<ColumnHint>();
            ResultSetsAdapter.ResultSetColumnInfo.updateResultSetColumnList(resultRetColumns, columns, hints);
            if (hints.isEmpty()) {
                hints = null;
            }
            PropertyValueValidationUtil.validateProperty((DesignElementHandle)setHandle, (String)"resultSet", columns);
            PropertyValueValidationUtil.validateProperty((DesignElementHandle)setHandle, (String)"columnHints", hints);
        }
        setHandle.getElement().setProperty("columnHints", hints);
        setHandle.getElement().setProperty("resultSet", columns);
        String queryText = setDesign.getQueryText();
        PropertyValueValidationUtil.validateProperty((DesignElementHandle)setHandle, (String)"queryText", (Object)queryText);
        setHandle.getElement().setProperty("queryText", (Object)queryText);
        String resultSetName = setDesign.getPrimaryResultSetName();
        PropertyValueValidationUtil.validateProperty((DesignElementHandle)setHandle, (String)"resultSetName", (Object)queryText);
        setHandle.getElement().setProperty("resultSetName", (Object)resultSetName);
        String odaValues = this.serializeOdaValues(setDesign);
        PropertyValueValidationUtil.validateProperty((DesignElementHandle)setHandle, (String)"designerValues", (Object)odaValues);
        setHandle.getElement().setProperty("designerValues", (Object)odaValues);
        this.updateROMMessageFile(setDesign.getDataSourceDesign(), setHandle.getModuleHandle());
    }

    private String serializeOdaValues(DataSetDesign setDesign) {
        DataSetParameters params = SchemaConversionUtil.convertToAdapterParameters(setDesign.getParameters());
        ResultSets resultSets = setDesign.getResultSets();
        DesignValues values = ModelFactory.eINSTANCE.createDesignValues();
        values.setVersion("2.0");
        boolean hasData = false;
        if (params != null) {
            values.setDataSetParameters((DataSetParameters)EcoreUtil.copy((EObject)params));
            hasData = true;
        }
        if (resultSets != null) {
            values.setResultSets((ResultSets)EcoreUtil.copy((EObject)resultSets));
            hasData = true;
        }
        if (!hasData) {
            return "";
        }
        try {
            return SerializerImpl.instance().write(values);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected void processUpdateDataSetHandle(DataSetDesign setDesign, OdaDataSetHandle setHandle, boolean isSourceChanged, DataSetParameters requestParameters, ResultSets requestResultSets) throws SemanticException {
        if (setDesign == null || setHandle == null) {
            return;
        }
        DesignUtil.validateObject((EObject)setDesign);
        CommandStack stack = setHandle.getModuleHandle().getCommandStack();
        stack.startTrans(null);
        try {
            Property prop;
            int i;
            EList propList;
            setHandle.getElement().setProperty("extensionID", (Object)setDesign.getOdaExtensionDataSetId());
            setHandle.setName(setDesign.getName());
            setHandle.setDisplayName(setDesign.getDisplayName());
            setHandle.setDisplayNameKey(setDesign.getDisplayNameKey());
            Properties props = setDesign.getPublicProperties();
            if (props != null) {
                propList = props.getProperties();
                i = 0;
                while (i < propList.size()) {
                    prop = (Property)propList.get(i);
                    setHandle.setProperty(prop.getName(), (Object)prop.getValue());
                    ++i;
                }
            }
            if ((props = setDesign.getPrivateProperties()) != null) {
                propList = props.getProperties();
                i = 0;
                while (i < propList.size()) {
                    prop = (Property)propList.get(i);
                    setHandle.setPrivateDriverProperty(prop.getName(), prop.getValue());
                    ++i;
                }
            }
            ResultSetDefinition cachedResultDefn = null;
            if (requestResultSets != null && !requestResultSets.getResultSetDefinitions().isEmpty()) {
                cachedResultDefn = (ResultSetDefinition)requestResultSets.getResultSetDefinitions().get(0);
            }
            ResultSetsAdapter tmpAdapter = new ResultSetsAdapter(setHandle, setDesign);
            this.updateROMResultSets(setHandle, tmpAdapter, cachedResultDefn);
            setHandle.setResultSetName(setDesign.getPrimaryResultSetName());
            setHandle.setQueryText(setDesign.getQueryText());
            DataSetParameterAdapter dataParamAdapter = new DataSetParameterAdapter(setHandle, setDesign);
            dataParamAdapter.updateUserDefinedParameter(SchemaConversionUtil.convertToDesignParameters(requestParameters));
            this.updateROMDataSetParams(dataParamAdapter, requestParameters);
            DataSourceDesign sourceDesign = setDesign.getDataSourceDesign();
            if (sourceDesign != null) {
                OdaDataSourceHandle sourceHandle = (OdaDataSourceHandle)setHandle.getDataSource();
                DataSourceAdapter dataSourceAdapter = new DataSourceAdapter(!this.isLinkedParameter);
                if (isSourceChanged && sourceHandle != null && !sourceHandle.getModuleHandle().isReadOnly()) {
                    setHandle.setDataSource(sourceDesign.getName());
                    dataSourceAdapter.updateDataSourceHandle(sourceDesign, sourceHandle);
                }
                if (!(isSourceChanged || sourceHandle == null || sourceHandle.getModuleHandle().isReadOnly() || dataSourceAdapter.isEqualDataSourceDesign(dataSourceAdapter.createDataSourceDesign(sourceHandle), sourceDesign))) {
                    dataSourceAdapter.updateDataSourceHandle(sourceDesign, sourceHandle);
                }
            } else {
                setHandle.setDataSource(this.defaultDataSourceName);
            }
            this.updateDesignerValue(setDesign, setHandle, requestParameters, dataParamAdapter.getUserDefinedParams(), requestResultSets);
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    private void updateDataSetHandle(DataSetDesign setDesign, OdaDataSetHandle setHandle, boolean isSourceChanged, DataSetParameters requestParameters, ResultSets requestResultSets) throws SemanticException {
        if (setDesign == null || setHandle == null) {
            return;
        }
        DesignUtil.validateObject((EObject)setDesign);
        CommandStack stack = setHandle.getModuleHandle().getCommandStack();
        stack.startTrans(null);
        try {
            Property prop;
            int i;
            EList propList;
            setHandle.getElement().setProperty("extensionID", (Object)setDesign.getOdaExtensionDataSetId());
            setHandle.setName(setDesign.getName());
            setHandle.setDisplayName(setDesign.getDisplayName());
            setHandle.setDisplayNameKey(setDesign.getDisplayNameKey());
            Properties props = setDesign.getPublicProperties();
            if (props != null) {
                propList = props.getProperties();
                i = 0;
                while (i < propList.size()) {
                    prop = (Property)propList.get(i);
                    setHandle.setProperty(prop.getName(), (Object)prop.getValue());
                    ++i;
                }
            }
            if ((props = setDesign.getPrivateProperties()) != null) {
                propList = props.getProperties();
                i = 0;
                while (i < propList.size()) {
                    prop = (Property)propList.get(i);
                    setHandle.setPrivateDriverProperty(prop.getName(), prop.getValue());
                    ++i;
                }
            }
            ResultSetDefinition cachedResultDefn = null;
            if (requestResultSets != null && !requestResultSets.getResultSetDefinitions().isEmpty()) {
                cachedResultDefn = (ResultSetDefinition)requestResultSets.getResultSetDefinitions().get(0);
            }
            ResultSetsAdapter tmpAdapter = new ResultSetsAdapter(setHandle, setDesign);
            this.updateROMResultSets(setHandle, tmpAdapter, cachedResultDefn);
            setHandle.setResultSetName(setDesign.getPrimaryResultSetName());
            setHandle.setQueryText(setDesign.getQueryText());
            DataSetParameterAdapter dataParamAdapter = new DataSetParameterAdapter(setHandle, setDesign);
            dataParamAdapter.updateUserDefinedParameter(SchemaConversionUtil.convertToDesignParameters(requestParameters));
            this.updateROMDataSetParams(dataParamAdapter, requestParameters);
            DataSourceDesign sourceDesign = setDesign.getDataSourceDesign();
            if (sourceDesign != null) {
                OdaDataSourceHandle sourceHandle = (OdaDataSourceHandle)setHandle.getDataSource();
                DataSourceAdapter dataSourceAdapter = new DataSourceAdapter();
                if (isSourceChanged && sourceHandle != null && !sourceHandle.getModuleHandle().isReadOnly()) {
                    setHandle.setDataSource(sourceDesign.getName());
                    dataSourceAdapter.updateDataSourceHandle(sourceDesign, sourceHandle);
                }
                if (!(isSourceChanged || sourceHandle == null || sourceHandle.getModuleHandle().isReadOnly() || dataSourceAdapter.isEqualDataSourceDesign(dataSourceAdapter.createDataSourceDesign(sourceHandle), sourceDesign))) {
                    dataSourceAdapter.updateDataSourceHandle(sourceDesign, sourceHandle);
                }
            } else {
                setHandle.setDataSource(this.defaultDataSourceName);
            }
            this.updateDesignerValue(setDesign, setHandle, requestParameters, dataParamAdapter.getUserDefinedParams(), requestResultSets);
            this.updateROMMessageFile(sourceDesign, setHandle.getModuleHandle());
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    private void updateDesignerValue(DataSetDesign setDesign, OdaDataSetHandle setHandle, DataSetParameters requestParameters, List userDefinedList, ResultSets requestResultSets) throws SemanticException {
        DesignValues designerValues = null;
        org.eclipse.datatools.connectivity.oda.design.DataSetParameters setDefinedParams = setDesign.getParameters();
        if (setDefinedParams == null) {
            if (requestParameters != null) {
                designerValues = ModelFactory.eINSTANCE.createDesignValues();
                designerValues.setDataSetParameters(null);
            }
        } else {
            org.eclipse.datatools.connectivity.oda.design.DataSetParameters driverParams = DataSetParameterAdapter.getDriverDefinedParameters(setDefinedParams.getParameterDefinitions(), userDefinedList);
            if (driverParams.getParameterDefinitions().size() > 0) {
                designerValues = ModelFactory.eINSTANCE.createDesignValues();
                DataSetParameters adapterParams = SchemaConversionUtil.convertToAdapterParameters(driverParams);
                designerValues.setDataSetParameters(adapterParams);
                DataSetAdapter.clearReportParameterRelatedValues(adapterParams.getParameters(), setHandle.getModuleHandle());
            }
        }
        if (designerValues == null && requestResultSets == null) {
            setHandle.setDesignerValues(null);
            return;
        }
        if (requestResultSets != null) {
            if (designerValues == null) {
                designerValues = ModelFactory.eINSTANCE.createDesignValues();
                designerValues.setDataSetParameters(null);
            }
            designerValues.setResultSets(requestResultSets);
        } else {
            designerValues.setResultSets(null);
        }
        try {
            String dValue = SerializerImpl.instance().write(designerValues);
            setHandle.setDesignerValues(dValue);
        }
        catch (IOException iOException) {}
    }

    private static void clearReportParameterRelatedValues(EList<DataSetParameter> params, ModuleHandle module) {
        if (params == null) {
            return;
        }
        int i = 0;
        while (i < params.size()) {
            DataSetDesign setDesign;
            String setName;
            DynamicValuesQuery query;
            InputElementAttributes elementAttrs;
            DataSetParameter adapterParam = (DataSetParameter)params.get(i);
            ParameterDefinition param = adapterParam.getParameterDefinition();
            InputParameterAttributes paramAttrs = param.getInputAttributes();
            if (paramAttrs != null && (elementAttrs = paramAttrs.getElementAttributes()) != null && (query = elementAttrs.getDynamicValueChoices()) != null && module.findDataSet(setName = (setDesign = query.getDataSetDesign()).getName()) != null) {
                DynamicList cachedDynamic = ModelFactory.eINSTANCE.createDynamicList();
                cachedDynamic.setDataSetName(setName);
                cachedDynamic.setValueColumn(query.getValueColumn());
                cachedDynamic.setLabelColumn(query.getDisplayNameColumn());
                adapterParam.setDynamicList(cachedDynamic);
                elementAttrs.setDynamicValueChoices(null);
            }
            ++i;
        }
    }

    private void updateROMResultSets(OdaDataSetHandle setHandle, ResultSetsAdapter tmpAdapter, ResultSetDefinition cachedResultDefn) throws SemanticException {
        int i;
        List<ResultSetsAdapter.ResultSetColumnInfo> structList = tmpAdapter.newROMResultSets(cachedResultDefn);
        ArrayList<OdaResultSetColumn> columns = new ArrayList<OdaResultSetColumn>();
        ArrayList<ColumnHint> hints = new ArrayList<ColumnHint>();
        ResultSetsAdapter.ResultSetColumnInfo.updateResultSetColumnList(structList, columns, hints);
        PropertyHandle propHandle = setHandle.getPropertyHandle("resultSet");
        propHandle.clearValue();
        if (!columns.isEmpty()) {
            i = 0;
            while (i < columns.size()) {
                propHandle.addItem(columns.get(i));
                ++i;
            }
        }
        propHandle = setHandle.getPropertyHandle("columnHints");
        propHandle.clearValue();
        if (!hints.isEmpty()) {
            i = 0;
            while (i < hints.size()) {
                ColumnHint hint = (ColumnHint)hints.get(i);
                ColumnHintHandle oldHint = AdapterUtil.findColumnHint((String)hint.getProperty(null, "columnName"), setHandle.columnHintsIterator());
                if (oldHint == null) {
                    propHandle.addItem(hints.get(i));
                } else {
                    oldHint.setDisplayName((String)hint.getProperty(null, "displayName"));
                    oldHint.setDisplayNameKey((String)hint.getProperty(null, "displayNameID"));
                    oldHint.setHelpText((String)hint.getProperty(null, "helpText"));
                    oldHint.setHelpTextKey((String)hint.getProperty(null, "helpTextID"));
                    oldHint.setFormat((String)hint.getProperty(null, "format"));
                }
                ++i;
            }
        }
        List<IStructure> hints4ComputedColumn = tmpAdapter.getHintsForComputedColumn();
        int i2 = 0;
        while (i2 < hints4ComputedColumn.size()) {
            propHandle.addItem((IStructure)((ColumnHint)hints4ComputedColumn.get(i2)));
            ++i2;
        }
        tmpAdapter.updateROMFilterCondition();
    }

    private void updateROMDataSetParams(DataSetParameterAdapter setParamAdapter, DataSetParameters cachedParameters) throws SemanticException {
        List newParams = setParamAdapter.newROMSetParams(SchemaConversionUtil.convertToDesignParameters(cachedParameters));
        IdentifierUtility.updateParams2UniqueName(newParams);
        setParamAdapter.updateRomDataSetParamsWithNewParams(newParams);
    }
}

