/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.csveditor.view;

import hiro.yoshioka.eclipse.core.CoreUtil;
import hiro.yoshioka.sdh.CDHTableViewer;
import hiro.yoshioka.sdh.CSVRecordDataHolder;
import hiro.yoshioka.sdh.StringRecordDataHolder;
import hiro.yoshioka.sdh.diff.DiffToResultSetDataHolder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.part.ViewPart;

public class CDHDiffView
extends ViewPart {
    protected transient Log fLogger = LogFactory.getLog(((Object)((Object)this)).getClass());
    public static final String ID = "WolfCSVEditor.CsvDiffViewID";
    CSVRecordDataHolder cdh0;
    CSVRecordDataHolder cdh1;
    int[] fMatchingPos;
    private CDHTableViewer viewer0;
    private CDHTableViewer viewer1;

    public void createPartControl(Composite parent) {
        try {
            SashForm sash = new SashForm(parent, 256);
            this.viewer0 = new CDHTableViewer((Composite)sash, 101122);
            this.viewer0.setSupportDiff(true);
            this.viewer1 = new CDHTableViewer((Composite)sash, 101122);
            this.viewer1.setSupportDiff(true);
            this.viewer1.setMaxMultiLine(5);
            this.viewer1.setSupportChart(true);
            sash.setWeights(new int[]{3, 7});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setInput(IFile[] csvs, boolean isVirtual) throws CoreException {
        try {
            this.cdh0 = new CSVRecordDataHolder(CoreUtil.cnvFile((IFile)csvs[0]), csvs[0].getCharset(), null, true);
            this.cdh1 = new CSVRecordDataHolder(CoreUtil.cnvFile((IFile)csvs[1]), csvs[1].getCharset(), null, true);
            this.fMatchingPos = new int[1];
            String[] stringArray = this.cdh0.getKey();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String k = stringArray[n2];
                if ("title".equals(k)) break;
                this.fMatchingPos[0] = this.fMatchingPos[0] + 1;
                ++n2;
            }
            DiffToResultSetDataHolder differ = new DiffToResultSetDataHolder();
            try {
                differ.diffConfigure((StringRecordDataHolder)this.cdh0, (StringRecordDataHolder)this.cdh1, this.fMatchingPos);
                differ.diff();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.viewer0.setInputAdjustDatum(this.cdh0);
            this.viewer1.setInputAdjustDatum(this.cdh1);
            IViewSite viewSite = this.getViewSite();
            IActionBars actionBars = viewSite.getActionBars();
            IStatusLineManager manager = actionBars.getStatusLineManager();
            manager.setMessage(differ.getDiffInfomation());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setPartName(String partName) {
        super.setPartName(partName);
    }

    public void setFocus() {
        this.viewer0.getControl().setFocus();
    }
}

