/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.InsecureTrustManager;
import com.gargoylesoftware.htmlunit.SocksSocketFactory;
import com.gargoylesoftware.htmlunit.WebClientOptions;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.http.HttpHost;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

final class HtmlUnitSSLSocketFactory
extends org.apache.http.conn.ssl.SSLSocketFactory {
    private static final String SSL3ONLY = "htmlunit.SSL3Only";

    static void setUseSSL3Only(HttpParams parameters, boolean ssl3Only) {
        parameters.setParameter(SSL3ONLY, (Object)ssl3Only);
    }

    static boolean isUseSSL3Only(HttpParams parameters) {
        return parameters.getBooleanParameter(SSL3ONLY, false);
    }

    public static org.apache.http.conn.ssl.SSLSocketFactory buildSSLSocketFactory(WebClientOptions options) {
        try {
            if (!options.isUseInsecureSSL()) {
                if (options.getSSLClientCertificateUrl() == null) {
                    return new HtmlUnitSSLSocketFactory((KeyStore)null, null);
                }
                return new HtmlUnitSSLSocketFactory(HtmlUnitSSLSocketFactory.getKeyStore(options), options.getSSLClientCertificatePassword());
            }
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(HtmlUnitSSLSocketFactory.getKeyManagers(options), new TrustManager[]{new InsecureTrustManager()}, null);
            HtmlUnitSSLSocketFactory factory = new HtmlUnitSSLSocketFactory(sslContext, org.apache.http.conn.ssl.SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            return factory;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private HtmlUnitSSLSocketFactory(SSLContext sslContext, X509HostnameVerifier hostnameVerifier) {
        super(sslContext, hostnameVerifier);
    }

    private HtmlUnitSSLSocketFactory(KeyStore keystore, String keystorePassword) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        super(keystore, keystorePassword);
    }

    public Socket createSocket(HttpParams params) throws IOException {
        if (SocksSocketFactory.getSocksProxy(params) != null) {
            return null;
        }
        Socket socket = super.createSocket(params);
        this.configureSocket((SSLSocket)socket, params);
        return socket;
    }

    private void configureSocket(SSLSocket sslSocket, HttpParams params) {
        if (HtmlUnitSSLSocketFactory.isUseSSL3Only(params)) {
            sslSocket.setEnabledProtocols(new String[]{"SSLv3"});
        }
    }

    public Socket connectSocket(Socket socket, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        HttpHost socksProxy = SocksSocketFactory.getSocksProxy(params);
        if (socksProxy != null) {
            Socket underlying = SocksSocketFactory.createSocketWithSocksProxy(socksProxy);
            underlying.setReuseAddress(true);
            int connTimeout = HttpConnectionParams.getConnectionTimeout((HttpParams)params);
            int soTimeout = HttpConnectionParams.getSoTimeout((HttpParams)params);
            InetSocketAddress socksProxyAddress = new InetSocketAddress(socksProxy.getHostName(), socksProxy.getPort());
            try {
                underlying.setSoTimeout(soTimeout);
                underlying.connect(remoteAddress, connTimeout);
            }
            catch (SocketTimeoutException ex) {
                throw new ConnectTimeoutException("Connect to " + socksProxyAddress + " timed out");
            }
            Socket sslSocket = this.getSSLSocketFactory().createSocket(underlying, socksProxy.getHostName(), socksProxy.getPort(), true);
            this.configureSocket((SSLSocket)sslSocket, params);
            return sslSocket;
        }
        return super.connectSocket(socket, remoteAddress, localAddress, params);
    }

    private SSLSocketFactory getSSLSocketFactory() {
        try {
            Field field = org.apache.http.conn.ssl.SSLSocketFactory.class.getDeclaredField("socketfactory");
            field.setAccessible(true);
            return (SSLSocketFactory)field.get((Object)this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static KeyManager[] getKeyManagers(WebClientOptions options) {
        if (options.getSSLClientCertificateUrl() == null) {
            return null;
        }
        try {
            String password = options.getSSLClientCertificatePassword();
            char[] passwordChars = password != null ? password.toCharArray() : null;
            KeyStore keyStore = HtmlUnitSSLSocketFactory.getKeyStore(options);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            keyManagerFactory.init(keyStore, passwordChars);
            return keyManagerFactory.getKeyManagers();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static KeyStore getKeyStore(WebClientOptions options) {
        try {
            KeyStore keyStore = KeyStore.getInstance(options.getSSLClientCertificateType());
            String password = options.getSSLClientCertificatePassword();
            char[] passwordChars = password != null ? password.toCharArray() : null;
            keyStore.load(options.getSSLClientCertificateUrl().openStream(), passwordChars);
            return keyStore;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

