/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.plugin;

import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.designer.ui.preferences.PreferenceFactory;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.internal.CrosstabModelUtil;
import org.eclipse.birt.report.item.crosstab.core.de.internal.ICrosstabModelListener;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabAdaptUtil;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.Action;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class CrosstabPlugin
extends AbstractUIPlugin {
    public static final String ID = "org.eclipse.birt.report.item.crosstab.ui";
    public static final String PREFERENCE_FILTER_LIMIT = "Filter.Limit";
    public static final String PREFERENCE_AUTO_DEL_BINDINGS = "Auto.Del.Bindings";
    public static final String CUBE_BUILDER_WARNING_PREFERENCE = "org.eclipse.birt.report.designer.ui.cubebuilder.warning";
    public static final int FILTER_LIMIT_DEFAULT = 100;
    public static final String AUTO_DEL_BINDING_DEFAULT = "prompt";
    private static CrosstabPlugin plugin;

    public CrosstabPlugin() {
        plugin = this;
    }

    public static CrosstabPlugin getDefault() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        PreferenceFactory.getInstance().getPreferences((AbstractUIPlugin)CrosstabPlugin.getDefault()).setDefault(PREFERENCE_FILTER_LIMIT, 100);
        PreferenceFactory.getInstance().getPreferences((AbstractUIPlugin)CrosstabPlugin.getDefault()).setDefault(PREFERENCE_AUTO_DEL_BINDINGS, AUTO_DEL_BINDING_DEFAULT);
        PreferenceFactory.getInstance().getPreferences((AbstractUIPlugin)CrosstabPlugin.getDefault()).setDefault(CUBE_BUILDER_WARNING_PREFERENCE, AUTO_DEL_BINDING_DEFAULT);
        CrosstabModelUtil.setCrosstabModelListener((ICrosstabModelListener)new ICrosstabModelListener(){

            public void onCreated(int type, Object model) {
                if (type == 1 && model instanceof CrosstabCellHandle) {
                    CrosstabCellHandle cellHandle = (CrosstabCellHandle)model;
                    if (cellHandle.getContents().size() > 0) {
                        return;
                    }
                    LabelHandle labelHandle = DesignElementFactory.getInstance((ModuleHandle)cellHandle.getModuleHandle()).newLabel(null);
                    try {
                        labelHandle.setText(((MeasureViewHandle)cellHandle.getContainer()).getCubeMeasureName());
                        cellHandle.addContent((DesignElementHandle)labelHandle);
                    }
                    catch (SemanticException e) {
                        ExceptionUtil.handle((Throwable)e);
                    }
                }
            }

            public void onValidate(int type, Object model) {
                AggregationCellHandle cellHandle;
                if (type == 2 && model instanceof AggregationCellHandle && (cellHandle = (AggregationCellHandle)model).getContents().size() == 1 && cellHandle.getContents().get(0) instanceof DataItemHandle) {
                    MeasureViewHandle measureView = (MeasureViewHandle)cellHandle.getContainer();
                    DataItemHandle dataItem = (DataItemHandle)cellHandle.getContents().get(0);
                    CrosstabAdaptUtil.formatDataItem(measureView.getCubeMeasure(), dataItem);
                    if (measureView.getCubeMeasure() == null) {
                        return;
                    }
                    ActionHandle actionHandle = measureView.getCubeMeasure().getActionHandle();
                    if (actionHandle != null) {
                        try {
                            dataItem.setAction((Action)actionHandle.getStructure().copy());
                        }
                        catch (SemanticException e) {
                            ExceptionUtil.handle((Throwable)e);
                        }
                    }
                }
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
        CrosstabModelUtil.setCrosstabModelListener(null);
    }
}

