/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.re.executor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.engine.adapter.ExpressionUtil;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.IExecutorContext;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.item.crosstab.core.de.AbstractCrosstabItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.FactoryPropertyHandle;
import org.eclipse.birt.report.model.api.HideRuleHandle;
import org.eclipse.birt.report.model.api.HighlightRuleHandle;
import org.eclipse.birt.report.model.api.MemberHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.StyleRuleHandle;
import org.eclipse.birt.report.model.api.TOCHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ContentUtil {
    private ContentUtil() {
    }

    static void processStyle(IExecutorContext context, IContent content, AbstractCrosstabItemHandle handle, IBaseResultSet evaluator, Map styleCache) throws BirtException {
        IStyle style = ContentUtil.processStyle(context.getReportContent(), handle, evaluator, styleCache);
        if (style != null && !style.isEmpty()) {
            content.setInlineStyle(style);
        }
    }

    static IStyle processStyle(IReportContent reportContent, AbstractCrosstabItemHandle handle, IBaseResultSet evaluator, Map styleCache) throws BirtException {
        ReportElementHandle modelHandle = ContentUtil.getReportElementHandle(handle);
        if (modelHandle == null || reportContent == null || evaluator == null) {
            return null;
        }
        Iterator highlightRules = null;
        Iterator<Object> highlightCondExprs = null;
        if (styleCache != null) {
            Object[] cachedData = (Object[])styleCache.get(modelHandle);
            if (cachedData != null) {
                List exprs;
                List rules = (List)cachedData[0];
                if (rules != null) {
                    highlightRules = rules.iterator();
                }
                if ((exprs = (List)cachedData[1]) != null) {
                    highlightCondExprs = exprs.iterator();
                }
            } else {
                ArrayList<HighlightRuleHandle> rules = null;
                List<Object> exprs = null;
                StyleHandle privateStyle = modelHandle.getPrivateStyle();
                if (privateStyle != null) {
                    rules = new ArrayList<HighlightRuleHandle>();
                    exprs = new ArrayList();
                    Iterator itr = privateStyle.highlightRulesIterator();
                    while (itr != null && itr.hasNext()) {
                        rules.add((HighlightRuleHandle)itr.next());
                    }
                    if (rules.isEmpty()) {
                        rules = null;
                    } else {
                        exprs = ContentUtil.setupHighlightExprs(rules);
                        highlightRules = rules.iterator();
                        highlightCondExprs = exprs.iterator();
                    }
                }
                styleCache.put(modelHandle, new Object[]{rules, exprs});
            }
        } else {
            StyleHandle privateStyle = modelHandle.getPrivateStyle();
            if (privateStyle != null) {
                highlightRules = privateStyle.highlightRulesIterator();
            }
        }
        if (highlightRules == null) {
            return null;
        }
        IStyle highlightStyle = reportContent.createStyle();
        ContentUtil.setupHighlightStyle(modelHandle, highlightRules, highlightCondExprs, highlightStyle, evaluator);
        if (!highlightStyle.isEmpty()) {
            return highlightStyle;
        }
        return null;
    }

    private static List<IConditionalExpression> setupHighlightExprs(List<HighlightRuleHandle> rules) throws BirtException {
        ArrayList<IConditionalExpression> exprs = new ArrayList<IConditionalExpression>();
        DataRequestSession session = DataRequestSession.newSession((DataSessionContext)new DataSessionContext(3));
        try {
            IModelAdapter modelAdapter = session.getModelAdaptor();
            for (HighlightRuleHandle rule : rules) {
                IConditionalExpression expression = ContentUtil.convertHighlightExpression(rule, modelAdapter);
                exprs.add(expression);
            }
        }
        finally {
            session.shutdown();
        }
        return exprs;
    }

    private static IConditionalExpression convertHighlightExpression(HighlightRuleHandle rule, IModelAdapter modelAdapter) {
        ConditionalExpression condExpr = null;
        if (ModuleUtil.isListStyleRuleValue((StyleRuleHandle)rule)) {
            ArrayList<ScriptExpression> vals = null;
            List val1list = rule.getValue1ExpressionList().getListValue();
            if (val1list != null) {
                vals = new ArrayList<ScriptExpression>();
                for (Expression expr : val1list) {
                    vals.add(modelAdapter.adaptExpression(expr, IModelAdapter.ExpressionLocation.CUBE));
                }
            }
            condExpr = new ConditionalExpression((IScriptExpression)modelAdapter.adaptExpression((Expression)rule.getExpressionProperty("testExpr").getValue(), IModelAdapter.ExpressionLocation.CUBE), DataAdapterUtil.adaptModelFilterOperator((String)rule.getOperator()), vals);
        } else {
            Expression value1 = null;
            List val1list = rule.getValue1ExpressionList().getListValue();
            if (val1list != null && val1list.size() > 0) {
                value1 = (Expression)val1list.get(0);
            }
            condExpr = new ConditionalExpression((IScriptExpression)modelAdapter.adaptExpression((Expression)rule.getExpressionProperty("testExpr").getValue(), IModelAdapter.ExpressionLocation.CUBE), DataAdapterUtil.adaptModelFilterOperator((String)rule.getOperator()), (IBaseExpression)modelAdapter.adaptExpression(value1, IModelAdapter.ExpressionLocation.CUBE), (IBaseExpression)modelAdapter.adaptExpression((Expression)rule.getExpressionProperty("value2").getValue(), IModelAdapter.ExpressionLocation.CUBE));
        }
        return ExpressionUtil.transformConditionalExpression((IConditionalExpression)condExpr);
    }

    private static void setupHighlightStyle(ReportElementHandle handle, Iterator<HighlightRuleHandle> highlightRules, Iterator<IConditionalExpression> cachedHighlightCondExprs, IStyle style, IBaseResultSet evaluator) throws BirtException {
        if (cachedHighlightCondExprs != null) {
            while (highlightRules.hasNext()) {
                HighlightRuleHandle rule = highlightRules.next();
                IConditionalExpression expression = cachedHighlightCondExprs.next();
                Object value = evaluator.evaluate((IBaseExpression)expression);
                if (!(value instanceof Boolean) || !((Boolean)value).booleanValue()) continue;
                ContentUtil.setupRuleStyle((StructureHandle)rule, style);
            }
            return;
        }
        DataRequestSession session = DataRequestSession.newSession((DataSessionContext)new DataSessionContext(3));
        try {
            IModelAdapter modelAdapter = session.getModelAdaptor();
            while (highlightRules.hasNext()) {
                HighlightRuleHandle rule = highlightRules.next();
                IConditionalExpression expression = ContentUtil.convertHighlightExpression(rule, modelAdapter);
                Object value = evaluator.evaluate((IBaseExpression)expression);
                if (!(value instanceof Boolean) || !((Boolean)value).booleanValue()) continue;
                ContentUtil.setupRuleStyle((StructureHandle)rule, style);
            }
        }
        finally {
            session.shutdown();
        }
    }

    static void processVisibility(IExecutorContext context, IContent content, AbstractCrosstabItemHandle handle, IBaseResultSet evaluator) throws BirtException {
        String visibleFormat = ContentUtil.processVisibility(handle, evaluator);
        if (visibleFormat != null) {
            IStyle style = content.getInlineStyle();
            if (style == null) {
                style = context.getReportContent().createStyle();
                content.setInlineStyle(style);
            }
            style.setVisibleFormat(visibleFormat);
        }
    }

    static String processVisibility(AbstractCrosstabItemHandle handle, IBaseResultSet evaluator) throws BirtException {
        ReportItemHandle modelHandle = ContentUtil.getReportItemHandle(handle);
        if (modelHandle == null || evaluator == null) {
            return null;
        }
        Iterator visItr = modelHandle.visibilityRulesIterator();
        if (visItr != null && visItr.hasNext()) {
            StringBuffer buffer = new StringBuffer();
            while (visItr.hasNext()) {
                boolean isHidden;
                HideRuleHandle rule = (HideRuleHandle)visItr.next();
                String expr = ContentUtil.validExpression(rule.getExpression());
                Object result = null;
                if (expr != null) {
                    result = evaluator.evaluate(expr);
                }
                if (result == null || !(result instanceof Boolean) || !(isHidden = ((Boolean)result).booleanValue())) continue;
                buffer.append(rule.getFormat()).append(", ");
            }
            int len = buffer.length();
            if (len > 2) {
                buffer.delete(len - 2, len);
            }
            return buffer.toString();
        }
        return null;
    }

    static void processScope(IExecutorContext context, ICellContent content, CrosstabCellHandle handle, IBaseResultSet evaluator) throws BirtException {
        if (handle == null || evaluator == null || handle.getModelHandle() == null) {
            return;
        }
        String scope = handle.getModelHandle().getStringProperty("scope");
        if (scope != null) {
            content.setScope(scope);
        }
    }

    static void processHeaders(IExecutorContext context, ICellContent content, CrosstabCellHandle handle, IBaseResultSet evaluator) throws BirtException {
        Object tmp;
        if (handle == null || evaluator == null || handle.getModelHandle() == null) {
            return;
        }
        String headers = handle.getModelHandle().getStringProperty("headers");
        if (headers != null && (tmp = evaluator.evaluate(ContentUtil.validExpression(headers))) != null && !tmp.equals("")) {
            content.setHeaders(tmp.toString());
        }
    }

    static void processBookmark(IExecutorContext context, IContent content, AbstractCrosstabItemHandle handle, IBaseResultSet evaluator) throws BirtException {
        Object tmp;
        TOCHandle toc;
        Object tmp2;
        ReportItemHandle modelHandle = ContentUtil.getReportItemHandle(handle);
        if (modelHandle == null || evaluator == null) {
            return;
        }
        String bookmark = modelHandle.getBookmark();
        if (bookmark != null && (tmp2 = evaluator.evaluate(ContentUtil.validExpression(bookmark))) != null && !tmp2.equals("")) {
            content.setBookmark(tmp2.toString());
        }
        if ((toc = modelHandle.getTOC()) != null && (tmp = evaluator.evaluate(ContentUtil.validExpression(toc.getExpression()))) != null) {
            content.setTOC(tmp);
        }
    }

    static void processAction(IExecutorContext context, IContent content, AbstractCrosstabItemHandle handle) {
    }

    private static String validExpression(String expr) {
        if (expr != null && expr.trim().length() > 0) {
            return expr;
        }
        return null;
    }

    private static ReportItemHandle getReportItemHandle(AbstractCrosstabItemHandle handle) {
        if (handle != null && handle.getModelHandle() instanceof ReportItemHandle) {
            return (ReportItemHandle)handle.getModelHandle();
        }
        return null;
    }

    private static ReportElementHandle getReportElementHandle(AbstractCrosstabItemHandle handle) {
        if (handle != null && handle.getModelHandle() instanceof ReportElementHandle) {
            return (ReportElementHandle)handle.getModelHandle();
        }
        return null;
    }

    private static IStyle setupRuleStyle(StructureHandle highlight, IStyle style) {
        String value = ContentUtil.getMemberProperty(highlight, "backgroundColor");
        if (value != null) {
            style.setBackgroundColor(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "textAlign")) != null) {
            style.setTextAlign(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "textIndent")) != null) {
            style.setTextIndent(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "textUnderline")) != null) {
            style.setTextUnderline(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "textLineThrough")) != null) {
            style.setTextLineThrough(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "textOverline")) != null) {
            style.setTextOverline(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "textTransform")) != null) {
            style.setTextTransform(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "fontFamily")) != null) {
            style.setFontFamily(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "color")) != null) {
            style.setColor(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "fontSize")) != null) {
            style.setFontSize(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "fontStyle")) != null) {
            style.setFontStyle(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "fontWeight")) != null) {
            style.setFontWeight(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "fontVariant")) != null) {
            style.setFontVariant(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "borderBottomColor")) != null) {
            style.setBorderBottomColor(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "borderBottomStyle")) != null) {
            style.setBorderBottomStyle(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "borderBottomWidth")) != null) {
            style.setBorderBottomWidth(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "borderLeftColor")) != null) {
            style.setBorderLeftColor(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "borderLeftStyle")) != null) {
            style.setBorderLeftStyle(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "borderLeftWidth")) != null) {
            style.setBorderLeftWidth(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "borderRightColor")) != null) {
            style.setBorderRightColor(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "borderRightStyle")) != null) {
            style.setBorderRightStyle(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "borderRightWidth")) != null) {
            style.setBorderRightWidth(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "borderTopColor")) != null) {
            style.setBorderTopColor(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "borderTopStyle")) != null) {
            style.setBorderTopStyle(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "borderTopWidth")) != null) {
            style.setBorderTopWidth(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "numberAlign")) != null) {
            style.setNumberAlign(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "dateTimeFormat")) != null) {
            style.setDateFormat(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "numberFormat")) != null) {
            style.setNumberFormat(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "stringFormat")) != null) {
            style.setStringFormat(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "bidiTextDirection")) != null) {
            style.setDirection(value);
        }
        return style;
    }

    private static String getMemberProperty(StructureHandle handle, String name) {
        MemberHandle prop = handle.getMember(name);
        if (prop != null) {
            FactoryPropertyHandle propHandle;
            StyleHandle styleHandle;
            Object value = prop.getContext().getLocalValue(handle.getModule());
            if (value != null) {
                return prop.getStringValue();
            }
            if (handle instanceof HighlightRuleHandle && (styleHandle = ((HighlightRuleHandle)handle).getStyle()) != null && (propHandle = styleHandle.getFactoryPropertyHandle(name)) != null) {
                return propHandle.getStringValue();
            }
        }
        return null;
    }

    static DimensionType createDimension(DimensionHandle handle) {
        if (handle == null || !handle.isSet()) {
            return null;
        }
        if (handle.isKeyword()) {
            return new DimensionType(handle.getStringValue());
        }
        double measure = handle.getMeasure();
        String unit = handle.getUnits();
        return new DimensionType(measure, unit);
    }
}

