/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.netty.buffer;

import com.datastax.shaded.netty.buffer.ChannelBuffer;
import com.datastax.shaded.netty.buffer.ChannelBufferFactory;
import java.nio.ByteOrder;

public abstract class AbstractChannelBufferFactory
implements ChannelBufferFactory {
    private final ByteOrder defaultOrder;

    protected AbstractChannelBufferFactory() {
        this(ByteOrder.BIG_ENDIAN);
    }

    protected AbstractChannelBufferFactory(ByteOrder defaultOrder) {
        if (defaultOrder == null) {
            throw new NullPointerException("defaultOrder");
        }
        this.defaultOrder = defaultOrder;
    }

    public ChannelBuffer getBuffer(int capacity) {
        return this.getBuffer(this.getDefaultOrder(), capacity);
    }

    public ChannelBuffer getBuffer(byte[] array, int offset, int length) {
        return this.getBuffer(this.getDefaultOrder(), array, offset, length);
    }

    public ByteOrder getDefaultOrder() {
        return this.defaultOrder;
    }
}

