/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.netty.channel.local;

import com.datastax.shaded.netty.channel.Channel;
import com.datastax.shaded.netty.channel.local.LocalAddress;
import com.datastax.shaded.netty.util.internal.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

final class LocalChannelRegistry {
    private static final ConcurrentMap<LocalAddress, Channel> map = new ConcurrentHashMap<LocalAddress, Channel>();

    static boolean isRegistered(LocalAddress address) {
        return map.containsKey(address);
    }

    static Channel getChannel(LocalAddress address) {
        return (Channel)map.get(address);
    }

    static boolean register(LocalAddress address, Channel channel) {
        return map.putIfAbsent(address, channel) == null;
    }

    static boolean unregister(LocalAddress address) {
        return map.remove(address) != null;
    }

    private LocalChannelRegistry() {
    }
}

