/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ColorPalette {
    private static ColorPalette instance = null;
    private List<RGB> colorLib = new ArrayList<RGB>();
    private Stack<RGB> colorAvailable = new Stack();
    private HashMap<String, Color> hmColorUsed = new HashMap();

    private ColorPalette() {
        this.initColorLibrary();
        this.restore();
    }

    public static synchronized ColorPalette getInstance() {
        if (instance == null) {
            instance = new ColorPalette();
        }
        return instance;
    }

    private void initColorLibrary() {
        this.colorLib.add(new RGB(170, 200, 255));
        this.colorLib.add(new RGB(255, 255, 128));
        this.colorLib.add(new RGB(128, 255, 128));
        this.colorLib.add(new RGB(128, 255, 255));
        this.colorLib.add(new RGB(255, 128, 255));
        this.colorLib.add(new RGB(255, 128, 64));
        this.colorLib.add(new RGB(0, 255, 128));
        this.colorLib.add(new RGB(200, 156, 156));
        this.colorLib.add(new RGB(128, 128, 255));
        this.colorLib.add(new RGB(210, 210, 210));
        this.colorLib.add(new RGB(184, 184, 114));
        this.colorLib.add(new RGB(128, 128, 128));
        Collections.reverse(this.colorLib);
    }

    private Color getColor(RGB rgb) {
        if (rgb == null) {
            return null;
        }
        String key = rgb.toString();
        Color color = JFaceResources.getColorRegistry().get(key);
        if (color == null) {
            JFaceResources.getColorRegistry().put(key, rgb);
            color = JFaceResources.getColorRegistry().get(key);
        }
        return color;
    }

    private Color getAvailableColor() {
        RGB rgb;
        RGB rGB = rgb = this.colorAvailable.isEmpty() ? null : this.colorAvailable.pop();
        if (rgb == null) {
            return null;
        }
        return this.getColor(rgb);
    }

    public void putColor(String expression) {
        if (expression != null && expression.length() > 0 && !this.hmColorUsed.containsKey(expression = expression.toUpperCase())) {
            this.hmColorUsed.put(expression, this.getAvailableColor());
        }
    }

    public void retrieveColor(String expression) {
        if (expression != null && expression.length() > 0 && this.hmColorUsed.containsKey(expression = expression.toUpperCase())) {
            Color oldColor = this.hmColorUsed.remove(expression);
            this.colorAvailable.push(oldColor.getRGB());
        }
    }

    public Color getColor(String expression) {
        if (expression != null && expression.length() > 0) {
            return this.hmColorUsed.get(expression.toUpperCase());
        }
        return null;
    }

    public void restore() {
        this.colorAvailable.clear();
        this.colorAvailable.addAll(this.colorLib);
        this.hmColorUsed.clear();
    }

    public void updateKeys(Collection<String> keys) {
        HashSet<String> newKeys = new HashSet<String>();
        for (String key : keys) {
            newKeys.add(key.toUpperCase());
        }
        Set<String> oldKeys = this.hmColorUsed.keySet();
        HashSet<String> keysToRemove = new HashSet<String>(oldKeys);
        keysToRemove.removeAll(newKeys);
        for (String key : keysToRemove) {
            this.retrieveColor(key);
        }
        HashSet<String> keysToAdd = newKeys;
        keysToAdd.removeAll(oldKeys);
        for (String key : keysToAdd) {
            this.putColor(key);
        }
    }
}

