/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation.withaxes;

import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.computation.ValueFormatter;
import org.eclipse.birt.chart.computation.withaxes.AxisLabelTextProvider;
import org.eclipse.birt.chart.computation.withaxes.OneAxis;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.internal.factory.DateFormatWrapperFactory;
import org.eclipse.birt.chart.internal.factory.IDateFormatWrapper;
import org.eclipse.birt.chart.util.CDateTime;

final class DatetimeAxisLabelTextProvider
extends AxisLabelTextProvider {
    private CDateTime cdtMin;
    private int iUnit;
    private int iStep;
    private IDateFormatWrapper sdf;

    protected DatetimeAxisLabelTextProvider(OneAxis oax) {
        super(oax);
    }

    protected void init() {
        this.cdtMin = Methods.asDateTime(this.sc.getMinimum());
        this.iUnit = Methods.asInteger(this.sc.getUnit());
        this.iStep = Methods.asInteger(this.sc.getStep());
        if (this.axModel.getFormatSpecifier() == null) {
            this.sdf = DateFormatWrapperFactory.getPreferredDateFormat(this.iUnit, this.oax.getRunTimeContext().getULocale());
        }
    }

    public String getLabelText(int index) throws ChartException {
        CDateTime cdt = this.cdtMin.forward(this.iUnit, this.iStep * index);
        return ValueFormatter.format((Object)cdt, this.axModel.getFormatSpecifier(), this.oax.getRunTimeContext().getULocale(), this.sdf);
    }
}

