/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.Bytes;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBAddress;
import com.mongodb.DBApiLayer;
import com.mongodb.DBTCPConnector;
import com.mongodb.MongoException;
import com.mongodb.MongoOptions;
import com.mongodb.MongoURI;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.bson.io.PoolOutputBuffer;
import org.bson.util.SimplePool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mongo {
    public static final int MAJOR_VERSION = 2;
    public static final int MINOR_VERSION = 4;
    final ServerAddress _addr;
    final List<ServerAddress> _addrs;
    final MongoOptions _options;
    final DBTCPConnector _connector;
    final ConcurrentMap<String, DB> _dbs = new ConcurrentHashMap<String, DB>();
    private WriteConcern _concern = WriteConcern.NORMAL;
    final Bytes.OptionHolder _netOptions = new Bytes.OptionHolder(null);
    SimplePool<PoolOutputBuffer> _bufferPool = new SimplePool<PoolOutputBuffer>(1000){

        @Override
        protected PoolOutputBuffer createNew() {
            return new PoolOutputBuffer();
        }
    };

    public static DB connect(DBAddress addr) {
        return new Mongo(addr).getDB(addr.getDBName());
    }

    public Mongo() throws UnknownHostException, MongoException {
        this(new ServerAddress());
    }

    public Mongo(String host) throws UnknownHostException, MongoException {
        this(new ServerAddress(host));
    }

    public Mongo(String host, MongoOptions options) throws UnknownHostException, MongoException {
        this(new ServerAddress(host), options);
    }

    public Mongo(String host, int port) throws UnknownHostException, MongoException {
        this(new ServerAddress(host, port));
    }

    public Mongo(ServerAddress addr) throws MongoException {
        this(addr, new MongoOptions());
    }

    public Mongo(ServerAddress addr, MongoOptions options) throws MongoException {
        this._addr = addr;
        this._addrs = null;
        this._options = options;
        this._connector = new DBTCPConnector(this, this._addr);
        this._connector.checkMaster(true, true);
        this._connector.testMaster();
    }

    public Mongo(ServerAddress left, ServerAddress right) throws MongoException {
        this(left, right, new MongoOptions());
    }

    public Mongo(ServerAddress left, ServerAddress right, MongoOptions options) throws MongoException {
        this._addr = null;
        this._addrs = Arrays.asList(left, right);
        this._options = options;
        this._connector = new DBTCPConnector(this, this._addrs);
        this._connector.checkMaster(true, false);
        this._connector.testMaster();
    }

    public Mongo(List<ServerAddress> replicaSetSeeds) throws MongoException {
        this(replicaSetSeeds, new MongoOptions());
    }

    public Mongo(List<ServerAddress> replicaSetSeeds, MongoOptions options) throws MongoException {
        this._addr = null;
        this._addrs = replicaSetSeeds;
        this._options = options;
        this._connector = new DBTCPConnector(this, this._addrs);
        this._connector.checkMaster(true, false);
    }

    public Mongo(MongoURI uri) throws MongoException, UnknownHostException {
        this._options = uri.getOptions();
        if (uri.getHosts().size() == 1) {
            this._addr = new ServerAddress(uri.getHosts().get(0));
            this._addrs = null;
            this._connector = new DBTCPConnector(this, this._addr);
            this._connector.testMaster();
        } else {
            ArrayList<ServerAddress> replicaSetSeeds = new ArrayList<ServerAddress>(uri.getHosts().size());
            for (String host : uri.getHosts()) {
                replicaSetSeeds.add(new ServerAddress(host));
            }
            this._addr = null;
            this._addrs = replicaSetSeeds;
            this._connector = new DBTCPConnector(this, replicaSetSeeds);
            this._connector.checkMaster(true, true);
        }
    }

    public DB getDB(String dbname) {
        DB db = (DB)this._dbs.get(dbname);
        if (db != null) {
            return db;
        }
        db = new DBApiLayer(this, dbname, this._connector);
        DB temp = this._dbs.putIfAbsent(dbname, db);
        if (temp != null) {
            return temp;
        }
        return db;
    }

    public List<String> getDatabaseNames() throws MongoException {
        BasicDBObject cmd = new BasicDBObject();
        cmd.put("listDatabases", (Object)1);
        CommandResult res = this.getDB("admin").command(cmd);
        if (res.getInt("ok", 0) != 1) {
            throw new MongoException("error listing databases : " + res);
        }
        List l = (List)res.get("databases");
        ArrayList<String> list = new ArrayList<String>();
        for (Object o : l) {
            list.add(((BasicDBObject)o).getString("name"));
        }
        return list;
    }

    public void dropDatabase(String dbName) throws MongoException {
        this.getDB(dbName).dropDatabase();
    }

    public String getVersion() {
        return "2.4";
    }

    public String debugString() {
        return this._connector.debugString();
    }

    public String getConnectPoint() {
        return this._connector.getConnectPoint();
    }

    public ServerAddress getAddress() {
        return this._connector.getAddress();
    }

    public List<ServerAddress> getAllAddress() {
        List<ServerAddress> result = this._connector.getAllAddress();
        if (result == null) {
            return Arrays.asList(this.getAddress());
        }
        return result;
    }

    public void close() {
        this._connector.close();
    }

    public void setWriteConcern(WriteConcern concern) {
        this._concern = concern;
    }

    public WriteConcern getWriteConcern() {
        return this._concern;
    }

    public void slaveOk() {
        this.addOption(4);
    }

    public void addOption(int option) {
        this._netOptions.add(option);
    }

    public void setOptions(int options) {
        this._netOptions.set(options);
    }

    public void resetOptions() {
        this._netOptions.reset();
    }

    public int getOptions() {
        return this._netOptions.get();
    }

    public static class Holder {
        private static final ConcurrentMap<String, Mongo> _mongos = new ConcurrentHashMap<String, Mongo>();

        public Mongo connect(MongoURI uri) throws MongoException, UnknownHostException {
            String key = this._toKey(uri);
            Mongo m = (Mongo)_mongos.get(key);
            if (m != null) {
                return m;
            }
            m = new Mongo(uri);
            Mongo temp = _mongos.putIfAbsent(key, m);
            if (temp == null) {
                return m;
            }
            m.close();
            return temp;
        }

        String _toKey(MongoURI uri) {
            StringBuilder buf = new StringBuilder();
            for (String h : uri.getHosts()) {
                buf.append(h).append(",");
            }
            buf.append(uri.getOptions());
            buf.append(uri.getUsername());
            return buf.toString();
        }
    }
}

