/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.CaseInsensitiveColumnMatcher;
import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.ColumnMatcher;
import com.healthmarketscience.jackcess.Cursor;
import com.healthmarketscience.jackcess.Index;
import com.healthmarketscience.jackcess.IndexData;
import com.healthmarketscience.jackcess.RowId;
import com.healthmarketscience.jackcess.SimpleColumnMatcher;
import com.healthmarketscience.jackcess.Table;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexCursor
extends Cursor {
    private static final Log LOG = LogFactory.getLog(IndexCursor.class);
    private final IndexDirHandler _forwardDirHandler = new ForwardIndexDirHandler();
    private final IndexDirHandler _reverseDirHandler = new ReverseIndexDirHandler();
    private final Index _index;
    private final IndexData.EntryCursor _entryCursor;
    private Set<String> _indexEntryPattern;

    private IndexCursor(Table table, Index index, IndexData.EntryCursor entryCursor) throws IOException {
        super(new Cursor.Id(table, index), table, new IndexPosition(entryCursor.getFirstEntry()), new IndexPosition(entryCursor.getLastEntry()));
        this._index = index;
        this._index.initialize();
        this._entryCursor = entryCursor;
    }

    public static IndexCursor createCursor(Table table, Index index) throws IOException {
        return IndexCursor.createCursor(table, index, null, null);
    }

    public static IndexCursor createCursor(Table table, Index index, Object[] startRow, Object[] endRow) throws IOException {
        return IndexCursor.createCursor(table, index, startRow, true, endRow, true);
    }

    public static IndexCursor createCursor(Table table, Index index, Object[] startRow, boolean startInclusive, Object[] endRow, boolean endInclusive) throws IOException {
        if (table != index.getTable()) {
            throw new IllegalArgumentException("Given index is not for given table: " + index + ", " + table);
        }
        if (!table.getFormat().INDEXES_SUPPORTED) {
            throw new IllegalArgumentException("JetFormat " + table.getFormat() + " does not currently support index lookups");
        }
        if (index.getIndexData().isReadOnly()) {
            throw new IllegalArgumentException("Given index " + index + " is not usable for indexed lookups because it is read-only");
        }
        IndexCursor cursor = new IndexCursor(table, index, index.cursor(startRow, startInclusive, endRow, endInclusive));
        cursor.setColumnMatcher(null);
        return cursor;
    }

    public Index getIndex() {
        return this._index;
    }

    @Deprecated
    public boolean findRowByEntry(Object ... entryValues) throws IOException {
        return this.findFirstRowByEntry(entryValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean findFirstRowByEntry(Object ... entryValues) throws IOException {
        Cursor.Position curPos = this._curPos;
        Cursor.Position prevPos = this._prevPos;
        boolean found = false;
        try {
            boolean bl = found = this.findFirstRowByEntryImpl(this.toRowValues(entryValues), true);
            return bl;
        }
        finally {
            if (!found) {
                try {
                    this.restorePosition(curPos, prevPos);
                }
                catch (IOException e) {
                    LOG.error((Object)"Failed restoring position", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findClosestRowByEntry(Object ... entryValues) throws IOException {
        Cursor.Position curPos = this._curPos;
        Cursor.Position prevPos = this._prevPos;
        boolean found = false;
        try {
            this.findFirstRowByEntryImpl(this.toRowValues(entryValues), false);
            found = true;
        }
        finally {
            if (!found) {
                try {
                    this.restorePosition(curPos, prevPos);
                }
                catch (IOException e) {
                    LOG.error((Object)"Failed restoring position", (Throwable)e);
                }
            }
        }
    }

    public boolean currentRowMatchesEntry(Object ... entryValues) throws IOException {
        return this.currentRowMatchesEntryImpl(this.toRowValues(entryValues));
    }

    public Iterator<Map<String, Object>> entryIterator(Object ... entryValues) {
        return this.entryIterator(null, entryValues);
    }

    public Iterator<Map<String, Object>> entryIterator(Collection<String> columnNames, Object ... entryValues) {
        return new EntryIterator(columnNames, this.toRowValues(entryValues));
    }

    public Iterable<Map<String, Object>> entryIterable(Object ... entryValues) {
        return this.entryIterable(null, entryValues);
    }

    public Iterable<Map<String, Object>> entryIterable(final Collection<String> columnNames, final Object ... entryValues) {
        return new Iterable<Map<String, Object>>(){

            @Override
            public Iterator<Map<String, Object>> iterator() {
                return new EntryIterator(columnNames, IndexCursor.this.toRowValues(entryValues));
            }
        };
    }

    @Override
    protected IndexDirHandler getDirHandler(boolean moveForward) {
        return moveForward ? this._forwardDirHandler : this._reverseDirHandler;
    }

    @Override
    protected boolean isUpToDate() {
        return super.isUpToDate() && this._entryCursor.isUpToDate();
    }

    @Override
    protected void reset(boolean moveForward) {
        this._entryCursor.reset(moveForward);
        super.reset(moveForward);
    }

    @Override
    protected void restorePositionImpl(Cursor.Position curPos, Cursor.Position prevPos) throws IOException {
        if (!(curPos instanceof IndexPosition) || !(prevPos instanceof IndexPosition)) {
            throw new IllegalArgumentException("Restored positions must be index positions");
        }
        this._entryCursor.restorePosition(((IndexPosition)curPos).getEntry(), ((IndexPosition)prevPos).getEntry());
        super.restorePositionImpl(curPos, prevPos);
    }

    @Override
    protected boolean findNextRowImpl(Column columnPattern, Object valuePattern) throws IOException {
        if (!this.isBeforeFirst()) {
            return super.findNextRowImpl(columnPattern, valuePattern);
        }
        Object[] rowValues = this._entryCursor.getIndexData().constructIndexRow(columnPattern.getName(), valuePattern);
        if (rowValues == null) {
            return super.findNextRowImpl(columnPattern, valuePattern);
        }
        if (!this.findPotentialRow(rowValues, true)) {
            return false;
        }
        return this.currentRowMatches(columnPattern, valuePattern);
    }

    protected boolean findFirstRowByEntryImpl(Object[] rowValues, boolean requireMatch) throws IOException {
        if (!this.findPotentialRow(rowValues, requireMatch)) {
            return false;
        }
        if (!requireMatch) {
            return true;
        }
        return this.currentRowMatchesEntryImpl(rowValues);
    }

    @Override
    protected boolean findNextRowImpl(Map<String, ?> rowPattern) throws IOException {
        if (!this.isBeforeFirst()) {
            return super.findNextRowImpl(rowPattern);
        }
        IndexData indexData = this._entryCursor.getIndexData();
        Object[] rowValues = indexData.constructIndexRow(rowPattern);
        if (rowValues == null) {
            return super.findNextRowImpl(rowPattern);
        }
        if (!this.findPotentialRow(rowValues, true)) {
            return false;
        }
        Map<String, ?> indexRowPattern = null;
        if (rowPattern.size() == indexData.getColumns().size()) {
            indexRowPattern = rowPattern;
        } else {
            LinkedHashMap tmpRowPattern = new LinkedHashMap();
            indexRowPattern = tmpRowPattern;
            for (IndexData.ColumnDescriptor idxCol : indexData.getColumns()) {
                tmpRowPattern.put(idxCol.getName(), rowValues[idxCol.getColumnIndex()]);
            }
        }
        while (this.currentRowMatches(indexRowPattern)) {
            if (rowPattern == indexRowPattern || this.currentRowMatches(rowPattern)) {
                return true;
            }
            if (this.moveToNextRow()) continue;
        }
        return false;
    }

    private boolean currentRowMatchesEntryImpl(Object[] rowValues) throws IOException {
        if (this._indexEntryPattern == null) {
            this._indexEntryPattern = new HashSet<String>();
            for (IndexData.ColumnDescriptor col : this.getIndex().getColumns()) {
                this._indexEntryPattern.add(col.getName());
            }
        }
        Map<String, Object> row = this.getCurrentRow(this._indexEntryPattern);
        for (IndexData.ColumnDescriptor col : this.getIndex().getColumns()) {
            String columnName = col.getName();
            Object patValue = rowValues[col.getColumnIndex()];
            Object rowValue = row.get(columnName);
            if (this._columnMatcher.matches(this.getTable(), columnName, patValue, rowValue)) continue;
            return false;
        }
        return true;
    }

    private boolean findPotentialRow(Object[] rowValues, boolean requireMatch) throws IOException {
        this._entryCursor.beforeEntry(rowValues);
        IndexData.Entry startEntry = this._entryCursor.getNextEntry();
        if (requireMatch && !startEntry.getRowId().isValid()) {
            return false;
        }
        this.restorePosition(new IndexPosition(startEntry));
        return true;
    }

    private Object[] toRowValues(Object[] entryValues) {
        return this._entryCursor.getIndexData().constructIndexRowFromEntry(entryValues);
    }

    @Override
    protected Cursor.Position findAnotherPosition(Table.RowState rowState, Cursor.Position curPos, boolean moveForward) throws IOException {
        IndexDirHandler handler = this.getDirHandler(moveForward);
        IndexPosition endPos = (IndexPosition)handler.getEndPosition();
        IndexData.Entry entry = handler.getAnotherEntry();
        return !entry.equals(endPos.getEntry()) ? new IndexPosition(entry) : endPos;
    }

    @Override
    protected ColumnMatcher getDefaultColumnMatcher() {
        if (this.getIndex().isUnique()) {
            return CaseInsensitiveColumnMatcher.INSTANCE;
        }
        return SimpleColumnMatcher.INSTANCE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EntryIterator
    extends Cursor.BaseIterator {
        private final Object[] _rowValues;

        private EntryIterator(Collection<String> columnNames, Object[] rowValues) {
            super(columnNames);
            this._rowValues = rowValues;
            try {
                this._hasNext = IndexCursor.this.findFirstRowByEntryImpl(rowValues, true);
                this._validRow = this._hasNext;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        protected boolean findNext() throws IOException {
            return IndexCursor.this.moveToNextRow() && IndexCursor.this.currentRowMatchesEntryImpl(this._rowValues);
        }
    }

    private static final class IndexPosition
    extends Cursor.Position {
        private final IndexData.Entry _entry;

        private IndexPosition(IndexData.Entry entry) {
            this._entry = entry;
        }

        public RowId getRowId() {
            return this.getEntry().getRowId();
        }

        public IndexData.Entry getEntry() {
            return this._entry;
        }

        protected boolean equalsImpl(Object o) {
            return this.getEntry().equals(((IndexPosition)o).getEntry());
        }

        public String toString() {
            return "Entry = " + this.getEntry();
        }
    }

    private final class ReverseIndexDirHandler
    extends IndexDirHandler {
        private ReverseIndexDirHandler() {
        }

        public Cursor.Position getBeginningPosition() {
            return IndexCursor.this.getLastPosition();
        }

        public Cursor.Position getEndPosition() {
            return IndexCursor.this.getFirstPosition();
        }

        public IndexData.Entry getAnotherEntry() throws IOException {
            return IndexCursor.this._entryCursor.getPreviousEntry();
        }
    }

    private final class ForwardIndexDirHandler
    extends IndexDirHandler {
        private ForwardIndexDirHandler() {
        }

        public Cursor.Position getBeginningPosition() {
            return IndexCursor.this.getFirstPosition();
        }

        public Cursor.Position getEndPosition() {
            return IndexCursor.this.getLastPosition();
        }

        public IndexData.Entry getAnotherEntry() throws IOException {
            return IndexCursor.this._entryCursor.getNextEntry();
        }
    }

    private abstract class IndexDirHandler
    extends Cursor.DirHandler {
        private IndexDirHandler() {
        }

        public abstract IndexData.Entry getAnotherEntry() throws IOException;
    }
}

