/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.complex;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.complex.ComplexColumnInfo;
import com.healthmarketscience.jackcess.complex.ComplexDataType;
import com.healthmarketscience.jackcess.complex.ComplexValueForeignKey;
import com.healthmarketscience.jackcess.complex.UnsupportedValue;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnsupportedColumnInfo
extends ComplexColumnInfo<UnsupportedValue> {
    public UnsupportedColumnInfo(Column column, int complexId, Table typeObjTable, Table flatTable) throws IOException {
        super(column, complexId, typeObjTable, flatTable);
    }

    public List<Column> getValueColumns() {
        return this.getTypeColumns();
    }

    @Override
    public ComplexDataType getType() {
        return ComplexDataType.UNSUPPORTED;
    }

    @Override
    protected UnsupportedValueImpl toValue(ComplexValueForeignKey complexValueFk, Map<String, Object> rawValue) {
        int id = (Integer)this.getPrimaryKeyColumn().getRowValue(rawValue);
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        for (Column col : this.getValueColumns()) {
            col.setRowValue(values, col.getRowValue(rawValue));
        }
        return new UnsupportedValueImpl(id, complexValueFk, values);
    }

    @Override
    protected Object[] asRow(Object[] row, UnsupportedValue value) {
        super.asRow(row, value);
        Map<String, Object> values = value.getValues();
        for (Column col : this.getValueColumns()) {
            col.setRowValue(row, col.getRowValue(values));
        }
        return row;
    }

    public static UnsupportedValue newValue(Map<String, ?> values) {
        return UnsupportedColumnInfo.newValue(INVALID_COMPLEX_VALUE_ID, values);
    }

    public static UnsupportedValue newValue(ComplexValueForeignKey complexValueFk, Map<String, ?> values) {
        return new UnsupportedValueImpl(-1, complexValueFk, new LinkedHashMap(values));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnsupportedValueImpl
    extends ComplexColumnInfo.ComplexValueImpl
    implements UnsupportedValue {
        private Map<String, Object> _values;

        private UnsupportedValueImpl(int id, ComplexValueForeignKey complexValueFk, Map<String, Object> values) {
            super(id, complexValueFk);
            this._values = values;
        }

        @Override
        public Map<String, Object> getValues() {
            return this._values;
        }

        @Override
        public Object get(String columnName) {
            return this.getValues().get(columnName);
        }

        @Override
        public void set(String columnName, Object value) {
            this.getValues().put(columnName, value);
        }

        @Override
        public void update() throws IOException {
            this.getComplexValueForeignKey().updateUnsupportedValue(this);
        }

        @Override
        public void delete() throws IOException {
            this.getComplexValueForeignKey().deleteUnsupportedValue(this);
        }

        public String toString() {
            return "UnsupportedValue(" + this.getComplexValueForeignKey() + "," + this.getId() + ") " + this.getValues();
        }
    }
}

