/*
 * Decompiled with CFR 0.152.
 */
package org.graysky.eclipse.logwatcher.dialogs;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.graysky.eclipse.logwatcher.LogwatcherPlugin;
import org.graysky.eclipse.logwatcher.dialogs.AddSavedFilterDialog;
import org.graysky.eclipse.logwatcher.dialogs.SaveFilterDialog;
import org.graysky.eclipse.logwatcher.filters.Filter;
import org.graysky.eclipse.logwatcher.wizards.NewFilterWizard;

public class NewWatcherDialog
extends Dialog {
    private boolean m_editMode = false;
    private Combo m_fileCombo;
    private Text m_numLinesText;
    private Text m_intervalText;
    private String m_errorMsg;
    private File m_file;
    private int m_interval;
    private int m_numLines;
    private IDialogSettings m_settings;
    private org.eclipse.swt.widgets.List m_filterList;
    private Vector m_filters = new Vector();
    private Button m_wholeFileButton;
    private Label m_numLinesLabel;
    private static int DEFAULT_INTERVAL = 1;
    private static int DEFAULT_NUMLINES = 100;

    public NewWatcherDialog(Shell shell, boolean editMode) {
        super(shell);
        this.m_settings = LogwatcherPlugin.getDefault().getDialogSettings();
        this.m_editMode = editMode;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.m_editMode) {
            shell.setText("Edit Watcher");
        } else {
            shell.setText("Create New Watcher");
        }
    }

    public Vector getFilters() {
        return this.m_filters;
    }

    private void initControlsForFileSelection(String filename) {
        int defaultInterval = DEFAULT_INTERVAL;
        int defaultNumLines = DEFAULT_NUMLINES;
        try {
            defaultInterval = this.m_settings.getInt("interval-" + filename);
            defaultNumLines = this.m_settings.getInt("numLines-" + filename);
        }
        catch (NumberFormatException numberFormatException) {}
        this.m_intervalText.setText(Integer.toString(defaultInterval));
        this.m_intervalText.setSelection(0);
        if (defaultNumLines == Integer.MAX_VALUE) {
            this.m_wholeFileButton.setSelection(true);
            this.m_numLinesText.setText(Integer.toString(DEFAULT_NUMLINES));
            this.m_numLinesLabel.setEnabled(false);
            this.m_numLinesText.setEnabled(false);
        } else {
            this.m_wholeFileButton.setSelection(false);
            this.m_numLinesLabel.setEnabled(true);
            this.m_numLinesText.setEnabled(true);
            this.m_numLinesText.setText(Integer.toString(defaultNumLines));
            this.m_numLinesText.setSelection(0);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        Button chooserButton = this.createFileSelectionRow(composite);
        this.createRefreshIntervalRow(composite);
        this.createNumLinesGUI(composite);
        this.createFilterGUI(composite);
        chooserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                FileDialog dialog = new FileDialog(NewWatcherDialog.this.getShell(), 4);
                dialog.open();
                if (dialog.getFileName().length() > 0) {
                    NewWatcherDialog.this.m_fileCombo.setText(String.valueOf(dialog.getFilterPath()) + File.separator + dialog.getFileName());
                    NewWatcherDialog.this.initControlsForFileSelection(NewWatcherDialog.this.m_fileCombo.getText());
                }
            }
        });
        this.handleEditMode();
        return composite;
    }

    private void handleEditMode() {
        if (this.m_editMode) {
            this.m_fileCombo.setText(this.m_file.getAbsolutePath());
            this.m_intervalText.setText(Integer.toString(this.m_interval));
            if (this.m_numLines == 0) {
                this.m_numLinesText.setText(Integer.toString(DEFAULT_NUMLINES));
            } else {
                this.m_numLinesText.setText(Integer.toString(this.m_numLines));
            }
            this.m_numLinesLabel.setEnabled(false);
            this.m_numLinesText.setEnabled(false);
            this.m_wholeFileButton.setEnabled(false);
        }
    }

    private void createRefreshIntervalRow(Composite composite) {
        new Label(composite, 0).setText("Refresh interval (in seconds):");
        this.m_intervalText = new Text(composite, 2048);
        this.m_intervalText.setTextLimit(4);
        GridData gridData = new GridData(32);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 40;
        this.m_intervalText.setLayoutData((Object)gridData);
    }

    private Button createFileSelectionRow(Composite composite) {
        new Label(composite, 0).setText("Select a file to watch:");
        this.m_fileCombo = new Combo(composite, 4);
        this.initFileCombo();
        GridData gridData = new GridData();
        gridData.widthHint = 200;
        this.m_fileCombo.setLayoutData((Object)gridData);
        Button chooserButton = new Button(composite, 8);
        chooserButton.setText("Browse...");
        if (this.m_editMode) {
            this.m_fileCombo.setEnabled(false);
            chooserButton.setEnabled(false);
        }
        return chooserButton;
    }

    private void initFileCombo() {
        List watches = LogwatcherPlugin.getDefault().getRecentWatches();
        ListIterator iter = watches.listIterator(watches.size());
        while (iter.hasPrevious()) {
            String item = (String)iter.previous();
            this.m_fileCombo.add(item);
        }
        this.m_fileCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewWatcherDialog.this.initControlsForFileSelection(NewWatcherDialog.this.m_fileCombo.getText());
            }
        });
    }

    protected void createNumLinesGUI(Composite parent) {
        Group numLinesGroup = new Group(parent, 0);
        numLinesGroup.setText("Number of lines to show at start");
        GridLayout glayout = new GridLayout(2, false);
        numLinesGroup.setLayout((Layout)glayout);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        numLinesGroup.setLayoutData((Object)gridData);
        this.m_wholeFileButton = new Button((Composite)numLinesGroup, 32);
        this.m_wholeFileButton.setText("Show entire file");
        gridData = new GridData(512);
        gridData.horizontalSpan = 2;
        this.m_wholeFileButton.setLayoutData((Object)gridData);
        this.m_numLinesLabel = new Label((Composite)numLinesGroup, 0);
        this.m_numLinesLabel.setText("Number of lines:");
        gridData = new GridData(512);
        gridData.horizontalSpan = 1;
        gridData.widthHint = 140;
        this.m_numLinesLabel.setLayoutData((Object)gridData);
        this.m_numLinesText = new Text((Composite)numLinesGroup, 2048);
        this.m_numLinesText.setTextLimit(4);
        gridData = new GridData(2);
        gridData.horizontalSpan = 1;
        gridData.widthHint = 40;
        this.m_numLinesText.setLayoutData((Object)gridData);
        this.m_wholeFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (NewWatcherDialog.this.m_wholeFileButton.getSelection()) {
                    NewWatcherDialog.this.m_numLinesLabel.setEnabled(false);
                    NewWatcherDialog.this.m_numLinesText.setEnabled(false);
                } else {
                    NewWatcherDialog.this.m_numLinesLabel.setEnabled(true);
                    NewWatcherDialog.this.m_numLinesText.setEnabled(true);
                }
            }
        });
    }

    protected void createFilterGUI(Composite parent) {
        Group filterGroup = new Group(parent, 0);
        filterGroup.setText("Filters");
        GridLayout glayout = new GridLayout(2, false);
        filterGroup.setLayout((Layout)glayout);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        filterGroup.setLayoutData((Object)gridData);
        this.m_filterList = new org.eclipse.swt.widgets.List((Composite)filterGroup, 2818);
        gridData = new GridData(512);
        gridData.widthHint = 300;
        gridData.heightHint = 120;
        gridData.verticalSpan = 4;
        this.m_filterList.setLayoutData((Object)gridData);
        Button newButton = new Button((Composite)filterGroup, 8);
        newButton.setText("New Filter...");
        newButton.setLayoutData((Object)new GridData(2));
        Button addButton = new Button((Composite)filterGroup, 8);
        addButton.setText("Add Saved Filter...");
        addButton.setLayoutData((Object)new GridData(2));
        final Button saveButton = new Button((Composite)filterGroup, 8);
        saveButton.setText("Save Filter...");
        saveButton.setLayoutData((Object)new GridData(2));
        saveButton.setEnabled(false);
        final Button removeButton = new Button((Composite)filterGroup, 8);
        removeButton.setText("Remove Filter");
        removeButton.setLayoutData((Object)new GridData(2));
        removeButton.setEnabled(false);
        final Button removeAllButton = new Button((Composite)filterGroup, 8);
        removeAllButton.setText("Remove All");
        removeAllButton.setLayoutData((Object)new GridData(2));
        removeAllButton.setEnabled(this.m_filterList.getItemCount() > 0);
        newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                NewFilterWizard wizard = new NewFilterWizard(NewWatcherDialog.this.m_editMode);
                WizardDialog dialog = new WizardDialog(NewWatcherDialog.this.m_filterList.getShell(), (IWizard)wizard);
                int status = dialog.open();
                if (status == 0 && wizard.getFilter() != null) {
                    NewWatcherDialog.this.m_filters.add(wizard.getFilter());
                    NewWatcherDialog.this.m_filterList.add(wizard.getFilter().getDescription());
                }
                removeAllButton.setEnabled(NewWatcherDialog.this.m_filterList.getItemCount() > 0);
            }
        });
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddSavedFilterDialog dialog = new AddSavedFilterDialog(NewWatcherDialog.this.getShell());
                dialog.open();
                NewWatcherDialog.this.m_filters.addAll(dialog.getFiltersToAdd());
                Iterator iter = dialog.getFiltersToAdd().iterator();
                while (iter.hasNext()) {
                    Filter filter = (Filter)iter.next();
                    NewWatcherDialog.this.m_filterList.add(filter.getDescription());
                }
            }
        });
        saveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int filterIndex = NewWatcherDialog.this.m_filterList.getSelectionIndex();
                Filter filter = (Filter)NewWatcherDialog.this.m_filters.get(filterIndex);
                SaveFilterDialog dialog = new SaveFilterDialog(NewWatcherDialog.this.getShell(), filter);
                if (dialog.open() == 0) {
                    LogwatcherPlugin.getDefault().addSavedFilter(filter);
                }
            }
        });
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                int[] selections = NewWatcherDialog.this.m_filterList.getSelectionIndices();
                int i = 0;
                while (i < selections.length) {
                    NewWatcherDialog.this.m_filterList.remove(selections[i]);
                    NewWatcherDialog.this.m_filters.remove(selections[i]);
                    if (NewWatcherDialog.this.m_filterList.getSelectionCount() == 0) {
                        removeButton.setEnabled(false);
                    }
                    removeAllButton.setEnabled(NewWatcherDialog.this.m_filterList.getItemCount() > 0);
                    saveButton.setEnabled(false);
                    ++i;
                }
            }
        });
        removeAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                NewWatcherDialog.this.m_filterList.removeAll();
                NewWatcherDialog.this.m_filters.clear();
                removeButton.setEnabled(false);
                removeAllButton.setEnabled(false);
                saveButton.setEnabled(false);
            }
        });
        this.m_filterList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (NewWatcherDialog.this.m_filterList.getSelectionCount() == 1) {
                    saveButton.setEnabled(true);
                } else {
                    saveButton.setEnabled(false);
                }
                if (NewWatcherDialog.this.m_filterList.getSelectionCount() > 0) {
                    removeButton.setEnabled(true);
                } else {
                    removeButton.setEnabled(false);
                }
            }
        });
        if (this.m_editMode) {
            Iterator iter = this.m_filters.iterator();
            while (iter.hasNext()) {
                Filter element = (Filter)iter.next();
                this.m_filterList.add(element.getDescription());
            }
        }
    }

    public File getFile() {
        return this.m_file;
    }

    public void setFile(File f) {
        this.m_file = f;
    }

    public int getInterval() {
        return this.m_interval;
    }

    public int getNumLines() {
        return this.m_numLines;
    }

    public void setInterval(int interval) {
        this.m_interval = interval;
    }

    public void setNumLines(int numLines) {
        this.m_numLines = numLines;
    }

    public void setFilters(Vector filters) {
        this.m_filters = filters;
    }

    protected boolean validate() {
        Integer i;
        this.m_file = new File(this.m_fileCombo.getText());
        if (!this.m_file.exists() || !this.m_file.isFile()) {
            this.m_errorMsg = "File not found:\n" + this.m_fileCombo.getText();
            return false;
        }
        if (!this.m_file.canRead()) {
            this.m_errorMsg = "Cannot read file:\n" + this.m_fileCombo.getText();
            return false;
        }
        try {
            if (this.m_wholeFileButton.getSelection()) {
                this.m_numLines = Integer.MAX_VALUE;
            } else {
                i = new Integer(this.m_numLinesText.getText());
                if (i < 0) {
                    throw new NumberFormatException();
                }
                this.m_numLines = i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.m_errorMsg = "Number of lines to show must be a positive integer.";
            return false;
        }
        try {
            i = new Integer(this.m_intervalText.getText());
            if (i <= 0) {
                throw new NumberFormatException();
            }
            this.m_interval = i;
        }
        catch (NumberFormatException numberFormatException) {
            this.m_errorMsg = "Refresh interval must be a positive integer.";
            return false;
        }
        return true;
    }

    protected void okPressed() {
        if (this.validate()) {
            this.m_settings.put("interval-" + this.m_file.getAbsolutePath(), this.m_interval);
            this.m_settings.put("numLines-" + this.m_file.getAbsolutePath(), this.m_numLines);
            LogwatcherPlugin.getDefault().addRecentWatch(this.m_file.getAbsolutePath());
            super.okPressed();
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)"LogWatcher", (String)this.m_errorMsg);
        }
    }
}

