/*
 * Decompiled with CFR 0.152.
 */
package org.graysky.eclipse.logwatcher.filters;

import java.util.Iterator;
import java.util.Vector;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.eclipse.swt.custom.LineStyleEvent;
import org.graysky.eclipse.logwatcher.filters.FilterAction;
import org.graysky.eclipse.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Filter {
    private String m_pattern = null;
    private boolean m_caseSensitive = false;
    private Vector m_actions = new Vector();
    private boolean m_contains = true;
    private Pattern m_regexp = null;
    private Perl5Matcher m_matcher = new Perl5Matcher();
    private String m_description;

    public boolean matches(String str) {
        boolean match = this.m_matcher.contains(str, this.m_regexp);
        if (this.m_contains) {
            return match;
        }
        return !match;
    }

    public void handleViewerMatch(LineStyleEvent event) {
        Iterator iter = this.m_actions.iterator();
        while (iter.hasNext()) {
            FilterAction action = (FilterAction)iter.next();
            action.doViewerAction(event);
        }
    }

    public String handleWatcherMatch(String line, boolean firstUpdate) {
        Iterator iter = this.m_actions.iterator();
        if (iter.hasNext()) {
            FilterAction action = (FilterAction)iter.next();
            return action.doWatcherAction(line, firstUpdate);
        }
        return line;
    }

    public void addAction(FilterAction action) {
        this.m_actions.add(action);
    }

    public String getDescription() {
        String contains;
        if (this.m_description != null) {
            return this.m_description;
        }
        FilterAction a = (FilterAction)this.m_actions.get(0);
        String string = contains = this.m_contains ? "contains" : "does not contain";
        if (a != null) {
            return String.valueOf(a.getDescription()) + " when text " + contains + " \"" + this.m_pattern + "\"";
        }
        return "No action specified for filter";
    }

    public String getPattern() {
        return this.m_pattern;
    }

    public void setPattern(String pattern, boolean caseSensitive) throws MalformedPatternException {
        this.m_pattern = pattern;
        this.m_caseSensitive = caseSensitive;
        Perl5Compiler compiler = new Perl5Compiler();
        this.m_regexp = !this.m_caseSensitive ? compiler.compile(this.m_pattern, 1) : compiler.compile(this.m_pattern);
    }

    public boolean getContains() {
        return this.m_contains;
    }

    public void dispose() {
        Iterator iter = this.m_actions.iterator();
        while (iter.hasNext()) {
            FilterAction element = (FilterAction)iter.next();
            element.dispose();
        }
    }

    public void setContains(boolean contains) {
        this.m_contains = contains;
    }

    public boolean isCaseSensitive() {
        return this.m_caseSensitive;
    }

    public void toXML(Document doc, Node node) {
        Element filter = doc.createElement("filter");
        filter.appendChild(XmlUtils.createElementWithText(doc, "pattern", this.getPattern()));
        filter.appendChild(XmlUtils.createElementWithText(doc, "caseSensitive", Boolean.toString(this.isCaseSensitive())));
        filter.appendChild(XmlUtils.createElementWithText(doc, "contains", Boolean.toString(this.getContains())));
        filter.appendChild(XmlUtils.createElementWithText(doc, "description", this.getDescription()));
        Iterator iter = this.m_actions.iterator();
        while (iter.hasNext()) {
            FilterAction action = (FilterAction)iter.next();
            action.toXML(doc, filter);
        }
        node.appendChild(filter);
    }

    public void setDescription(String description) {
        this.m_description = description;
    }
}

