/*
 * Decompiled with CFR 0.152.
 */
package org.graysky.eclipse.logwatcher.wizards;

import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Perl5Compiler;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.graysky.eclipse.logwatcher.filters.Filter;

public class NewFilterWizardStart
extends WizardPage {
    private Text m_filterText;
    private Composite m_actionOptions;
    private Color m_color;
    private Combo m_actionsCombo;
    private Combo m_containsCombo;
    private Button m_caseSensitiveBox;
    private Perl5Compiler m_regExpCompiler = new Perl5Compiler();

    public NewFilterWizardStart(String pageName) {
        super(pageName);
    }

    public NewFilterWizardStart(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 20;
        composite.setLayout((Layout)layout);
        new Label(composite, 0).setText("Where text ");
        this.m_containsCombo = new Combo(composite, 12);
        this.m_containsCombo.add("contains");
        this.m_containsCombo.add("does not contain");
        this.m_containsCombo.select(0);
        this.m_filterText = new Text(composite, 2048);
        this.m_filterText.setTextLimit(200);
        GridData gridData = new GridData();
        gridData.widthHint = 200;
        this.m_filterText.setLayoutData((Object)gridData);
        this.m_filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewFilterWizardStart.this.setPageComplete(NewFilterWizardStart.this.validatePage());
            }
        });
        new Label(composite, 0).setText("Take this action:");
        this.m_actionsCombo = new Combo(composite, 12);
        this.m_actionsCombo.add("Highlight Line");
        this.m_actionsCombo.add("Skip Line");
        this.m_actionsCombo.add("Add Todo Task");
        this.m_actionsCombo.select(0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.m_actionsCombo.setLayoutData((Object)gridData);
        this.m_actionsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewFilterWizardStart.this.setPageComplete(NewFilterWizardStart.this.validatePage());
            }
        });
        this.m_caseSensitiveBox = new Button(composite, 32);
        this.m_caseSensitiveBox.setText("Case sensitive");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.m_caseSensitiveBox.setLayoutData((Object)gridData);
        this.setDescription("Text must be a valid regular expression.");
        this.setPageComplete(this.validatePage());
    }

    public String getTitle() {
        return "Define the filter.";
    }

    public int getActionType() {
        return this.m_actionsCombo.getSelectionIndex();
    }

    public Filter getFilter() {
        try {
            Filter f = new Filter();
            f.setPattern(this.m_filterText.getText(), this.m_caseSensitiveBox.getSelection());
            f.setContains(this.m_containsCombo.getSelectionIndex() == 0);
            return f;
        }
        catch (MalformedPatternException malformedPatternException) {
            return null;
        }
    }

    public IWizardPage getNextPage() {
        switch (this.m_actionsCombo.getSelectionIndex()) {
            case 0: {
                return this.getWizard().getPage("highlight_options");
            }
            case 2: {
                return this.getWizard().getPage("addTask_options");
            }
            case 1: {
                return null;
            }
        }
        return null;
    }

    protected boolean validatePage() {
        if (this.m_filterText.getText().length() > 0) {
            try {
                this.m_regExpCompiler.compile(this.m_filterText.getText());
                this.setErrorMessage(null);
                return true;
            }
            catch (MalformedPatternException e) {
                this.setErrorMessage("Invalid regular expression: " + e.getMessage());
                return false;
            }
        }
        return false;
    }
}

