/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.fisshplate.core.element;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.util.CellRangeAddress;
import org.seasar.fisshplate.context.FPContext;
import org.seasar.fisshplate.core.element.TemplateElement;
import org.seasar.fisshplate.exception.FPMergeException;
import org.seasar.fisshplate.wrapper.CellWrapper;

public abstract class AbstractCell
implements TemplateElement {
    protected CellWrapper cell;
    private boolean isMergedCell;
    private short relativeMergedColumnTo;
    private int relativeMergedRowNumTo;
    private Object cellValue;

    AbstractCell(CellWrapper cell) {
        this.cell = cell;
        HSSFSheet templateSheet = cell.getRow().getSheet().getHSSFSheet();
        int rowNum = cell.getRow().getHSSFRow().getRowNum();
        for (int i = 0; i < templateSheet.getNumMergedRegions(); ++i) {
            CellRangeAddress reg = templateSheet.getMergedRegion(i);
            this.setUpMergedCellInfo(cell.getHSSFCell().getColumnIndex(), rowNum, reg);
            if (this.isMergedCell) break;
        }
        this.cellValue = cell.getObjectValue();
    }

    public void merge(FPContext context) throws FPMergeException {
        HSSFCell out = context.getCurrentCell();
        this.copyCellStyle(context, out);
        this.mergeImpl(context, out);
        context.nextCell();
    }

    abstract void mergeImpl(FPContext var1, HSSFCell var2) throws FPMergeException;

    private void setUpMergedCellInfo(int cellNum, int rowNum, CellRangeAddress reg) {
        if (reg.getFirstColumn() != cellNum || reg.getFirstRow() != rowNum) {
            this.isMergedCell = false;
            return;
        }
        this.isMergedCell = true;
        this.relativeMergedColumnTo = (short)(reg.getLastColumn() - reg.getFirstColumn());
        this.relativeMergedRowNumTo = reg.getLastRow() - reg.getFirstRow();
    }

    protected void copyCellStyle(FPContext context, HSSFCell outCell) {
        HSSFCell hssfCell = this.cell.getHSSFCell();
        HSSFCellStyle outStyle = hssfCell.getCellStyle();
        outCell.setCellStyle(outStyle);
        if (this.isMergedCell) {
            this.mergeCell(context);
        }
    }

    private void mergeCell(FPContext context) {
        int columnFrom = context.getCurrentCellNum();
        int rowFrom = context.getCurrentRowNum();
        CellRangeAddress reg = new CellRangeAddress(rowFrom, rowFrom + this.relativeMergedRowNumTo, columnFrom, columnFrom + this.relativeMergedColumnTo);
        HSSFSheet hssfSheet = this.cell.getRow().getSheet().getHSSFSheet();
        hssfSheet.addMergedRegion(reg);
    }

    public Object getCellValue() {
        return this.cellValue;
    }

    public void setCellValue(Object cellValue) {
        this.cellValue = cellValue;
    }
}

