/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.fisshplate.core.element;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.seasar.fisshplate.context.FPContext;
import org.seasar.fisshplate.core.element.NullElement;
import org.seasar.fisshplate.core.element.Root;
import org.seasar.fisshplate.core.element.TemplateElement;
import org.seasar.fisshplate.core.parser.handler.CellParserHandler;
import org.seasar.fisshplate.exception.FPMergeException;
import org.seasar.fisshplate.wrapper.CellWrapper;
import org.seasar.fisshplate.wrapper.RowWrapper;

public class Row
implements TemplateElement {
    private List cellElementList = new ArrayList();
    private short rowHeight;
    private Root root;

    public Row(RowWrapper templateRow, Root root, CellParserHandler cellParserHandler) {
        this.root = root;
        if (templateRow.isNullRow()) {
            this.rowHeight = templateRow.getSheet().getHSSFSheet().getDefaultRowHeight();
            this.cellElementList.add(new NullElement());
            return;
        }
        HSSFRow hssfRow = templateRow.getHSSFRow();
        this.rowHeight = hssfRow.getHeight();
        for (int i = 0; i < templateRow.getCellCount(); ++i) {
            CellWrapper templateCell = templateRow.getCell(i);
            TemplateElement element = cellParserHandler.getElement(templateCell);
            this.cellElementList.add(element);
        }
    }

    public void merge(FPContext context) throws FPMergeException {
        if (context.shouldHeaderOut()) {
            context.setShouldHeaderOut(false);
            this.root.getPageHeader().merge(context);
        }
        context.setShouldFooterOut(true);
        HSSFRow outRow = context.createCurrentRow();
        outRow.setHeight(this.rowHeight);
        Map data = context.getData();
        data.put("rownum", new Integer(context.getCurrentRowNum() + 1));
        for (int i = 0; i < this.cellElementList.size(); ++i) {
            TemplateElement elem = (TemplateElement)this.cellElementList.get(i);
            elem.merge(context);
        }
        context.nextRow();
    }

    public short getRowHeight() {
        return this.rowHeight;
    }

    public List getCellElementList() {
        return this.cellElementList;
    }
}

