/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.fisshplate.core.element;

import java.util.Stack;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.seasar.fisshplate.context.FPContext;
import org.seasar.fisshplate.core.element.El;
import org.seasar.fisshplate.core.element.TemplateElement;
import org.seasar.fisshplate.exception.FPMergeException;

public class Suspend
implements TemplateElement {
    private El el;
    private Stack targetCellStack = new Stack();

    public Suspend(El el) {
        this.el = el;
    }

    public void merge(FPContext context) throws FPMergeException {
        context.addSuspendedSet(this);
        HSSFCell out = context.getCurrentCell();
        this.targetCellStack.push(out);
        this.el.targetElement.copyCellStyle(context, out);
        context.nextCell();
    }

    public void resume(FPContext context) throws FPMergeException {
        Object value = this.el.getBoundValue(context);
        this.el.targetElement.setCellValue(value);
        while (!this.targetCellStack.empty()) {
            HSSFCell out = (HSSFCell)this.targetCellStack.pop();
            this.el.targetElement.mergeImpl(context, out);
        }
    }

    public El getEl() {
        return this.el;
    }
}

