/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.content.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.content.IBandContent;
import org.eclipse.birt.report.engine.content.IElement;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.impl.ContainerContent;
import org.eclipse.birt.report.engine.ir.BandDesign;

public class AbstractBandContent
extends ContainerContent
implements IBandContent {
    int bandType = -1;
    protected static final short FIELD_TYPE = 900;

    AbstractBandContent(IBandContent content) {
        super(content);
        this.bandType = content.getBandType();
    }

    AbstractBandContent(IReportContent report) {
        super(report);
    }

    public int getBandType() {
        if (this.bandType == -1 && this.generateBy instanceof BandDesign) {
            BandDesign bandDesign = (BandDesign)this.generateBy;
            return bandDesign.getBandType();
        }
        return this.bandType;
    }

    public void setBandType(int bandType) {
        BandDesign bandDesign;
        if (this.generateBy instanceof BandDesign && bandType == (bandDesign = (BandDesign)this.generateBy).getBandType()) {
            bandType = -1;
            return;
        }
        this.bandType = bandType;
    }

    public String getGroupID() {
        IElement parent;
        int bandType = this.getBandType();
        if ((bandType == 3 || bandType == 4) && (parent = this.getParent()) instanceof IGroupContent) {
            IGroupContent group = (IGroupContent)parent;
            return group.getGroupID();
        }
        return null;
    }

    protected void writeFields(DataOutputStream out) throws IOException {
        super.writeFields(out);
        IOUtil.writeShort((OutputStream)out, (short)900);
        IOUtil.writeInt((OutputStream)out, (int)this.getBandType());
    }

    protected void readField(int version, int filedId, DataInputStream in, ClassLoader loader) throws IOException {
        switch (filedId) {
            case 900: {
                this.bandType = IOUtil.readInt((InputStream)in);
                break;
            }
            default: {
                super.readField(version, filedId, in, loader);
            }
        }
    }

    public boolean needSave() {
        if (this.bandType != -1) {
            return true;
        }
        return super.needSave();
    }
}

