/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.content.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.content.IDrillThroughAction;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.impl.DrillThroughAction;

public class ActionContent
implements IHyperlinkAction {
    protected int type = -1;
    protected String bookmark;
    protected String hyperlink;
    protected String tooltip;
    protected String target = null;
    protected IDrillThroughAction drillThrough;
    protected static final int VERSION = 0;
    static final int FIELD_NONE = -1;
    static final int FIELD_TYPE = 0;
    static final int FIELD_BOOKMARK = 1;
    static final int FIELD_HYPERLINK = 2;
    static final int FIELD_REPORTNAME = 3;
    static final int FIELD_PARAMETERBINDINGS = 4;
    static final int FIELD_SEARCHCRITERIA = 5;
    static final int FIELD_TARGET = 6;
    static final int FIELD_FORMAT = 7;
    static final int FIELD_ISBOOKMARK = 8;
    static final int FIELD_TARGETFILETYPE = 9;
    static final int FIELD_TOOLTIP = 10;

    public void setHyperlink(String hyperlink, String target) {
        this.type = 1;
        this.hyperlink = hyperlink;
        this.target = target;
    }

    public void setBookmark(String bookmark) {
        this.type = 2;
        this.bookmark = bookmark;
    }

    public void setDrillThrough(String bookmark, boolean isBookmark, String reportName, Map parameterBindings, Map searchCriteria, String target, String format) {
        this.setDrillThrough(bookmark, isBookmark, reportName, parameterBindings, searchCriteria, target, format, (String)null);
    }

    public void setDrillThrough(String bookmark, boolean isBookmark, String reportName, Map parameterBindings, Map searchCriteria, String target, String format, String targetFileType) {
        this.type = 3;
        this.drillThrough = new DrillThroughAction(bookmark, isBookmark, reportName, parameterBindings, searchCriteria, target, format, targetFileType);
    }

    public int getType() {
        return this.type;
    }

    public String getBookmark() {
        if (this.isDrillThrough()) {
            return this.drillThrough.getBookmark();
        }
        return this.bookmark;
    }

    public String getReportName() {
        assert (this.type == 3);
        if (this.isDrillThrough()) {
            return this.drillThrough.getReportName();
        }
        return null;
    }

    public void setReportName(String reportName) {
        assert (this.type == 3);
        if (this.isDrillThrough()) {
            this.drillThrough.setReportName(reportName);
        }
    }

    public Map getParameterBindings() {
        if (this.isDrillThrough()) {
            return this.drillThrough.getParameterBindings();
        }
        return null;
    }

    public Map getSearchCriteria() {
        assert (this.type == 3);
        if (this.isDrillThrough()) {
            return this.drillThrough.getSearchCriteria();
        }
        return null;
    }

    public String getTargetWindow() {
        if (this.isDrillThrough()) {
            return this.drillThrough.getTargetWindow();
        }
        return this.target;
    }

    public String getHyperlink() {
        return this.hyperlink;
    }

    protected void writeFields(DataOutputStream out) throws IOException {
        if (this.type != -1) {
            IOUtil.writeInt((OutputStream)out, (int)0);
            IOUtil.writeInt((OutputStream)out, (int)this.type);
        }
        if (this.isDrillThrough()) {
            if (this.drillThrough.getBookmark() != null) {
                IOUtil.writeInt((OutputStream)out, (int)1);
                IOUtil.writeString((DataOutputStream)out, (String)this.drillThrough.getBookmark());
            }
        } else if (this.bookmark != null) {
            IOUtil.writeInt((OutputStream)out, (int)1);
            IOUtil.writeString((DataOutputStream)out, (String)this.bookmark);
        }
        if (this.isDrillThrough() && this.drillThrough.isBookmark()) {
            IOUtil.writeInt((OutputStream)out, (int)8);
            IOUtil.writeBool((OutputStream)out, (boolean)this.drillThrough.isBookmark());
        }
        if (this.hyperlink != null) {
            IOUtil.writeInt((OutputStream)out, (int)2);
            IOUtil.writeString((DataOutputStream)out, (String)this.hyperlink);
        }
        if (this.isDrillThrough() && this.drillThrough.getReportName() != null) {
            IOUtil.writeInt((OutputStream)out, (int)3);
            IOUtil.writeString((DataOutputStream)out, (String)this.drillThrough.getReportName());
        }
        if (this.isDrillThrough() && this.drillThrough.getParameterBindings() != null) {
            IOUtil.writeInt((OutputStream)out, (int)4);
            IOUtil.writeMap((DataOutputStream)out, (Map)this.drillThrough.getParameterBindings());
        }
        if (this.isDrillThrough() && this.drillThrough.getSearchCriteria() != null) {
            IOUtil.writeInt((OutputStream)out, (int)5);
            IOUtil.writeMap((DataOutputStream)out, (Map)this.drillThrough.getSearchCriteria());
        }
        if (this.isDrillThrough() && this.drillThrough.getTargetWindow() != null) {
            IOUtil.writeInt((OutputStream)out, (int)6);
            IOUtil.writeString((DataOutputStream)out, (String)this.drillThrough.getTargetWindow());
        } else if (this.target != null) {
            IOUtil.writeInt((OutputStream)out, (int)6);
            IOUtil.writeString((DataOutputStream)out, (String)this.target);
        }
        if (this.tooltip != null) {
            IOUtil.writeInt((OutputStream)out, (int)10);
            IOUtil.writeString((DataOutputStream)out, (String)this.tooltip);
        }
        if (this.isDrillThrough() && this.drillThrough.getFormat() != null) {
            IOUtil.writeInt((OutputStream)out, (int)7);
            IOUtil.writeString((DataOutputStream)out, (String)this.drillThrough.getFormat());
        }
        if (this.isDrillThrough() && this.drillThrough.getTargetFileType() != null) {
            IOUtil.writeInt((OutputStream)out, (int)9);
            IOUtil.writeString((DataOutputStream)out, (String)this.drillThrough.getTargetFileType());
        }
    }

    protected void readField(int version, int filedId, DataInputStream in, ClassLoader loader) throws IOException {
        switch (filedId) {
            case 0: {
                this.type = IOUtil.readInt((InputStream)in);
                if (this.type != 3) break;
                this.drillThrough = new DrillThroughAction();
                break;
            }
            case 1: {
                String bk = IOUtil.readString((DataInputStream)in);
                if (this.isDrillThrough()) {
                    this.drillThrough.setBookmark(bk);
                    break;
                }
                this.bookmark = bk;
                break;
            }
            case 2: {
                this.hyperlink = IOUtil.readString((DataInputStream)in);
                break;
            }
            case 3: {
                String name = IOUtil.readString((DataInputStream)in);
                if (!this.isDrillThrough()) break;
                this.drillThrough.setReportName(name);
                break;
            }
            case 4: {
                Map bindings = IOUtil.readMap((DataInputStream)in, (ClassLoader)loader);
                if (!this.isDrillThrough()) break;
                this.drillThrough.setParameterBindings(bindings);
                break;
            }
            case 5: {
                Map search = IOUtil.readMap((DataInputStream)in, (ClassLoader)loader);
                if (!this.isDrillThrough()) break;
                this.drillThrough.setSearchCriteria(search);
                break;
            }
            case 6: {
                String tgt = IOUtil.readString((DataInputStream)in);
                if (this.isDrillThrough()) {
                    this.drillThrough.setTargetWindow(tgt);
                    break;
                }
                this.target = tgt;
                break;
            }
            case 7: {
                String fmt = IOUtil.readString((DataInputStream)in);
                if (!this.isDrillThrough()) break;
                this.drillThrough.setFormat(fmt);
                break;
            }
            case 8: {
                boolean isBk = IOUtil.readBool((InputStream)in);
                if (!this.isDrillThrough()) break;
                this.drillThrough.setBookmarkType(isBk);
                break;
            }
            case 9: {
                String tgtType = IOUtil.readString((DataInputStream)in);
                if (!this.isDrillThrough()) break;
                this.drillThrough.setTargetFileType(tgtType);
                break;
            }
            case 10: {
                this.tooltip = IOUtil.readString((DataInputStream)in);
            }
        }
    }

    public void readObject(DataInputStream in, ClassLoader loader) throws IOException {
        int version = IOUtil.readInt((InputStream)in);
        int filedId = IOUtil.readInt((InputStream)in);
        while (filedId != -1) {
            this.readField(version, filedId, in, loader);
            filedId = IOUtil.readInt((InputStream)in);
        }
    }

    public void writeObject(DataOutputStream out) throws IOException {
        IOUtil.writeInt((OutputStream)out, (int)0);
        this.writeFields(out);
        IOUtil.writeInt((OutputStream)out, (int)-1);
    }

    public String getFormat() {
        if (this.isDrillThrough()) {
            return this.drillThrough.getFormat();
        }
        return null;
    }

    public void setBookmarkType(boolean isBookmark) {
        if (this.isDrillThrough()) {
            this.drillThrough.setBookmarkType(isBookmark);
        }
    }

    public boolean isBookmark() {
        if (this.isDrillThrough()) {
            return this.drillThrough.isBookmark();
        }
        return false;
    }

    public IDrillThroughAction getDrillThrough() {
        if (this.isDrillThrough()) {
            return this.drillThrough;
        }
        return null;
    }

    public void setDrillThrough(IDrillThroughAction drillThrough) {
        this.type = 3;
        this.drillThrough = drillThrough;
    }

    private boolean isDrillThrough() {
        return this.type == 3;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public String getTooltip() {
        return this.tooltip;
    }
}

