/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.content.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IContentVisitor;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.impl.AbstractContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.ir.ExtendedItemDesign;

public class ForeignContent
extends AbstractContent
implements IForeignContent {
    protected String rawType;
    protected Object rawValue;
    protected String rawKey;
    protected String altText;
    protected String altTextKey;
    protected static final short FIELD_RAW_TYPE = 400;
    protected static final short FIELD_RAWVALUE = 401;
    protected static final short FIELD_ALTTEXT = 402;
    protected static final short FIELD_ALTTEXTKEY = 403;
    protected static final short FIELD_RAWKEY = 404;

    ForeignContent(IForeignContent foreign) {
        super(foreign);
        this.rawType = foreign.getRawType();
        this.rawKey = foreign.getRawKey();
        this.rawValue = foreign.getRawValue();
        this.altText = foreign.getAltText();
        this.altTextKey = foreign.getAltTextKey();
    }

    public int getContentType() {
        return 4;
    }

    ForeignContent(ReportContent report) {
        super(report);
    }

    public ForeignContent(IContent content) {
        super(content);
    }

    public Object accept(IContentVisitor visitor, Object value) throws BirtException {
        return visitor.visitForeign(this, value);
    }

    public String getRawType() {
        return this.rawType;
    }

    public void setRawKey(String rawKey) {
        this.rawKey = rawKey;
    }

    public String getRawKey() {
        return this.rawKey;
    }

    public Object getRawValue() {
        return this.rawValue;
    }

    public void setRawType(String rawType) {
        this.rawType = rawType;
    }

    public void setRawValue(Object rawValue) {
        this.rawValue = rawValue;
    }

    public static String getTextRawType(String contentType, Object content) {
        String text;
        if ("plain".equals(contentType)) {
            return "text/plaintext";
        }
        if ("html".equals(contentType)) {
            return "text/html";
        }
        String string = text = content == null ? "" : content.toString().trim();
        if (text.length() > 6 && "<html>".equalsIgnoreCase(text.substring(0, 6))) {
            return "text/html";
        }
        return "text/plaintext";
    }

    public String getAltText() {
        if (this.altText == null && this.generateBy instanceof ExtendedItemDesign) {
            return ((ExtendedItemDesign)this.generateBy).getAltText();
        }
        return this.altText;
    }

    public String getAltTextKey() {
        if (this.altTextKey == null && this.generateBy instanceof ExtendedItemDesign) {
            return ((ExtendedItemDesign)this.generateBy).getAltTextKey();
        }
        return this.altTextKey;
    }

    public void setAltTextKey(String key) {
        this.altTextKey = key;
    }

    public void setAltText(String altText) {
        this.altText = altText;
    }

    protected void writeFields(DataOutputStream out) throws IOException {
        super.writeFields(out);
        if (this.rawType != null) {
            IOUtil.writeShort((OutputStream)out, (short)400);
            IOUtil.writeString((DataOutputStream)out, (String)this.rawType);
        }
        if (this.rawValue != null) {
            IOUtil.writeShort((OutputStream)out, (short)401);
            IOUtil.writeObject((DataOutputStream)out, (Object)this.rawValue);
        }
        if (this.altText != null) {
            IOUtil.writeShort((OutputStream)out, (short)402);
            IOUtil.writeString((DataOutputStream)out, (String)this.altText);
        }
        if (this.altTextKey != null) {
            IOUtil.writeShort((OutputStream)out, (short)403);
            IOUtil.writeString((DataOutputStream)out, (String)this.altTextKey);
        }
        if (this.rawKey != null) {
            IOUtil.writeShort((OutputStream)out, (short)404);
            IOUtil.writeString((DataOutputStream)out, (String)this.rawKey);
        }
    }

    protected void readField(int version, int filedId, DataInputStream in, ClassLoader loader) throws IOException {
        switch (filedId) {
            case 400: {
                this.rawType = IOUtil.readString((DataInputStream)in);
                break;
            }
            case 401: {
                this.rawValue = IOUtil.readObject((DataInputStream)in, (ClassLoader)loader);
                if (!this.rawType.equals("text/template") || !(this.rawValue instanceof HashMap)) break;
                Object[] objectArray = new Object[2];
                objectArray[1] = this.rawValue;
                this.rawValue = objectArray;
                break;
            }
            case 402: {
                this.altText = IOUtil.readString((DataInputStream)in);
                break;
            }
            case 403: {
                this.altTextKey = IOUtil.readString((DataInputStream)in);
                break;
            }
            case 404: {
                this.rawKey = IOUtil.readString((DataInputStream)in);
                break;
            }
            default: {
                super.readField(version, filedId, in, loader);
            }
        }
    }

    public boolean needSave() {
        if (this.rawType != null) {
            return true;
        }
        if (this.rawValue != null || this.rawKey != null) {
            return true;
        }
        if (this.altText != null || this.altTextKey != null) {
            return true;
        }
        return super.needSave();
    }

    protected IContent cloneContent() {
        return new ForeignContent(this);
    }
}

