/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v4;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.executor.PageVariable;
import org.eclipse.birt.report.engine.internal.document.IPageHintWriter;
import org.eclipse.birt.report.engine.internal.document.v4.PageHintWriterV4;
import org.eclipse.birt.report.engine.presentation.IPageHint;
import org.eclipse.birt.report.engine.presentation.InstanceIndex;
import org.eclipse.birt.report.engine.presentation.PageSection;
import org.eclipse.birt.report.engine.presentation.TableColumnHint;
import org.eclipse.birt.report.engine.presentation.UnresolvedRowHint;

public class FixedLayoutPageHintWriter
extends PageHintWriterV4
implements IPageHintWriter {
    public FixedLayoutPageHintWriter(IDocArchiveWriter writer) throws IOException {
        super(writer);
    }

    protected void init(IDocArchiveWriter writer) throws IOException {
        this.writer = writer;
        try {
            this.hintsStream = writer.createRandomAccessStream("/pages");
            this.hintsStream.writeInt(6);
            this.indexStream = writer.createRandomAccessStream("/pages_index");
            this.indexStream.writeLong(0L);
            this.indexStream.writeLong(-1L);
        }
        catch (IOException ex) {
            this.close();
            throw ex;
        }
    }

    protected void writePageHint(DataOutputStream out, IPageHint hint) throws IOException {
        IOUtil.writeLong((DataOutputStream)out, (long)hint.getPageNumber());
        IOUtil.writeString((DataOutputStream)out, (String)hint.getMasterPage());
        int sectionCount = hint.getSectionCount();
        IOUtil.writeInt((OutputStream)out, (int)sectionCount);
        int i = 0;
        while (i < sectionCount) {
            PageSection section = hint.getSection(i);
            section.write(out);
            ++i;
        }
        int hintSize = hint.getUnresolvedRowCount();
        IOUtil.writeInt((OutputStream)out, (int)hintSize);
        int i2 = 0;
        while (i2 < hintSize) {
            UnresolvedRowHint rowHint = hint.getUnresolvedRowHint(i2);
            rowHint.writeObject(out);
            ++i2;
        }
        int columnHintSize = hint.getTableColumnHintCount();
        IOUtil.writeInt((OutputStream)out, (int)columnHintSize);
        int i3 = 0;
        while (i3 < columnHintSize) {
            TableColumnHint columnHint = hint.getTableColumnHint(i3);
            IOUtil.writeString((DataOutputStream)out, (String)columnHint.getTableId());
            IOUtil.writeInt((OutputStream)out, (int)columnHint.getStart());
            IOUtil.writeInt((OutputStream)out, (int)columnHint.getColumnCount());
            ++i3;
        }
        Collection<PageVariable> variables = hint.getPageVariables();
        this.writePageVariables(out, variables);
    }

    protected void writeInstanceIndex(DataOutputStream out, InstanceIndex[] indexes) throws IOException {
        if (indexes == null) {
            IOUtil.writeInt((OutputStream)out, (int)0);
            return;
        }
        IOUtil.writeInt((OutputStream)out, (int)indexes.length);
        int i = 0;
        while (i < indexes.length) {
            IOUtil.writeString((DataOutputStream)out, (String)indexes[i].getInstanceID().toString());
            IOUtil.writeLong((DataOutputStream)out, (long)indexes[i].getOffset());
            ++i;
        }
    }
}

