/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.layout.ILayoutManager;
import org.eclipse.birt.report.engine.layout.html.HTMLAbstractLM;
import org.eclipse.birt.report.engine.layout.html.HTMLLayoutManagerFactory;
import org.eclipse.birt.report.engine.layout.html.HTMLStackingLM;

public abstract class HTMLInlineStackingLM
extends HTMLStackingLM {
    protected boolean initializedChildren = false;
    protected List childrenLayouts = new ArrayList();
    protected List childrenExecutors = new ArrayList();
    protected List childrenFinished = new ArrayList();

    public HTMLInlineStackingLM(HTMLLayoutManagerFactory factory) {
        super(factory);
    }

    public void initialize(HTMLAbstractLM parent, IContent content, IReportItemExecutor executor, IContentEmitter emitter) throws BirtException {
        super.initialize(parent, content, executor, emitter);
        this.initializedChildren = false;
    }

    public void close() throws BirtException {
        this.childrenLayouts.clear();
        this.childrenExecutors.clear();
        this.childrenFinished.clear();
        super.close();
    }

    private void initalizeChildren() throws BirtException {
        IContent childContent = null;
        while (this.executor.hasNextChild()) {
            IReportItemExecutor childExecutor = this.executor.getNextChild();
            childContent = childExecutor.execute();
            if (childContent == null) {
                this.childrenLayouts.add(null);
            } else {
                ILayoutManager childLayout = this.engine.createLayoutManager(this, childContent, childExecutor, this.emitter);
                this.childrenLayouts.add(childLayout);
            }
            this.childrenExecutors.add(childExecutor);
            this.childrenFinished.add(Boolean.FALSE);
        }
        if (childContent != null) {
            childContent.setLastChild(true);
        }
    }

    protected boolean resumeLayout() throws BirtException {
        boolean hasNextPage = false;
        int length = this.childrenLayouts.size();
        int i = 0;
        while (i < length) {
            boolean childFinished = (Boolean)this.childrenFinished.get(i);
            if (!childFinished) {
                ILayoutManager childLayout = (ILayoutManager)this.childrenLayouts.get(i);
                if (childLayout != null) {
                    boolean childHasNewPage = childLayout.layout();
                    if (childHasNewPage) {
                        hasNextPage = true;
                    }
                    childFinished = childLayout.isFinished();
                } else {
                    childFinished = true;
                }
                if (childFinished) {
                    if (childLayout != null) {
                        childLayout.close();
                    }
                    IReportItemExecutor childExecutor = (IReportItemExecutor)this.childrenExecutors.get(i);
                    childExecutor.close();
                }
                this.childrenFinished.set(i, childFinished);
            }
            ++i;
        }
        return hasNextPage;
    }

    protected boolean isChildrenFinished() {
        int size = this.childrenLayouts.size();
        int i = 0;
        while (i < size) {
            boolean childFinished = (Boolean)this.childrenFinished.get(i);
            if (!childFinished) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean layoutNodes() throws BirtException {
        if (!this.initializedChildren) {
            this.initializedChildren = true;
            this.initalizeChildren();
        }
        return this.resumeLayout();
    }
}

