/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html.buffer;

import java.util.ArrayList;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.emitter.ContentEmitterUtil;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.layout.html.buffer.AbstractNode;
import org.eclipse.birt.report.engine.layout.html.buffer.IContainerNode;
import org.eclipse.birt.report.engine.layout.html.buffer.INode;
import org.eclipse.birt.report.engine.layout.html.buffer.PageHintGenerator;

public class ContainerBufferNode
extends AbstractNode
implements IContainerNode {
    protected ArrayList children = new ArrayList();

    public ContainerBufferNode(IContent content, IContentEmitter emitter, PageHintGenerator generator, boolean isVisible) {
        super(content, emitter, generator, isVisible);
    }

    protected void flushChildren() throws BirtException {
        int size = this.children.size();
        int i = 0;
        while (i < size) {
            INode child = (INode)this.children.get(i);
            child.flush();
            ++i;
        }
    }

    public void flush() throws BirtException {
        if (!this.isStarted) {
            this.start();
        }
        this.flushChildren();
        this.end();
    }

    protected void flushUnStartedChildren() throws BirtException {
        int flushSize = this.children.size() - 1;
        if (flushSize > 0) {
            int i = 0;
            while (i < flushSize) {
                INode child = (INode)this.children.get(i);
                child.flush();
                ++i;
            }
            Object lastChild = this.children.get(flushSize);
            this.children.clear();
            this.children.add(lastChild);
        }
    }

    public void start() throws BirtException {
        if (this.isStarted) {
            return;
        }
        if (this.parent != null && !this.parent.isStarted()) {
            this.parent.start();
        }
        if (this.isVisible) {
            ContentEmitterUtil.startContent(this.content, this.emitter);
        }
        this.generator.start(this.content, this.isFirst);
        this.isStarted = true;
        this.flushUnStartedChildren();
    }

    public void addChild(INode node) {
        this.children.add(node);
    }

    public void removeChildren() {
        this.children.clear();
    }
}

