/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.impl;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.nLayout.LayoutContext;
import org.eclipse.birt.report.engine.nLayout.area.IArea;
import org.eclipse.birt.report.engine.nLayout.area.IContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.InlineStackingArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.LocalProperties;
import org.eclipse.birt.report.engine.nLayout.area.style.BoxStyle;

public class InlineContainerArea
extends InlineStackingArea
implements IContainerArea {
    protected transient InlineStackingArea lineParent = null;
    protected transient int lineCount = 1;

    public InlineContainerArea(ContainerArea parent, LayoutContext context, IContent content) {
        super(parent, context, content);
        this.isInlineStacking = true;
        this.lineParent = (InlineStackingArea)parent;
        this.isInInlineStacking = parent.isInInlineStacking;
    }

    public InlineContainerArea(InlineContainerArea area) {
        super(area);
    }

    protected void close(boolean isLastLine) throws BirtException {
        int contentWidth = this.currentIP;
        if (this.lineCount == 1 && this.specifiedWidth > contentWidth) {
            contentWidth = this.specifiedWidth;
        }
        this.setContentWidth(contentWidth);
        int height = 0;
        Iterator<IArea> iter = this.getChildren();
        while (iter.hasNext()) {
            AbstractArea child = (AbstractArea)iter.next();
            height = Math.max(height, child.getAllocatedHeight());
        }
        this.setContentHeight(height);
        this.updateBackgroundImage();
        if (this.children.size() > 0) {
            this.verticalAlign();
        }
        this.checkDisplayNone();
        if (isLastLine) {
            this.checkPageBreak();
            this.parent.add(this);
            this.parent.update(this);
            this.finished = true;
        } else {
            this.checkPageBreak();
            InlineContainerArea area = this.cloneArea();
            this.addToExtension(area);
            area.context = this.context;
            area.children = this.children;
            for (AbstractArea childArea : area.children) {
                childArea.setParent(area);
            }
            area.setParent(this.parent);
            this.children = new ArrayList();
            this.parent.addChild(area);
            this.parent.update(area);
            area.finished = true;
            this.currentIP = 0;
            height = 0;
        }
    }

    protected void addToExtension(InlineContainerArea area) {
    }

    public void close() throws BirtException {
        this.close(true);
        this.finished = true;
    }

    public void initialize() throws BirtException {
        IStyle style = this.content.getStyle();
        this.calculateSpecifiedWidth(this.content);
        if (style == null || style.isEmpty()) {
            this.hasStyle = false;
            this.boxStyle = BoxStyle.DEFAULT;
            this.localProperties = LocalProperties.DEFAULT;
        } else {
            this.buildProperties(this.content, this.context);
        }
        this.maxAvaWidth = this.parent.getCurrentMaxContentWidth();
        this.bookmark = this.content.getBookmark();
        this.action = this.content.getHyperlinkAction();
        this.vAlign = style != null ? style.getProperty(38) : null;
        this.currentIP = 0;
        this.currentBP = 0;
    }

    public InlineContainerArea cloneArea() {
        return new InlineContainerArea(this);
    }

    public void endLine(boolean endParagraph) throws BirtException {
        ++this.lineCount;
        if (this.getChildrenCount() > 0) {
            this.close(false);
        }
        if (this.lineParent != null) {
            this.lineParent.endLine(endParagraph);
            this.initialize();
        }
    }

    public int getMaxLineWidth() {
        return this.lineParent.getMaxLineWidth();
    }

    public boolean isEmptyLine() {
        if (this.getChildrenCount() > 0) {
            return false;
        }
        return this.lineParent.isEmptyLine();
    }

    public void setTextIndent(ITextContent content) {
        int ip = this.lineParent.getCurrentIP();
        this.lineParent.setTextIndent(content);
        if (ip != this.lineParent.getCurrentIP()) {
            this.maxAvaWidth = this.parent.getCurrentMaxContentWidth();
        }
    }

    public ContainerArea.SplitResult split(int height, boolean force) throws BirtException {
        return ContainerArea.SplitResult.SUCCEED_WITH_NULL;
    }

    public ContainerArea.SplitResult splitLines(int lineCount) throws BirtException {
        return ContainerArea.SplitResult.SUCCEED_WITH_NULL;
    }
}

