/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.yaml.dom;

import hiro.yoshioka.util.FileUtil;
import hiro.yoshioka.util.StringUtil;
import hiro.yoshioka.yaml.dom.AbsYamlElement;
import hiro.yoshioka.yaml.dom.ElementType;
import hiro.yoshioka.yaml.dom.IYamlElement;
import hiro.yoshioka.yaml.dom.YamlElement;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.ho.yaml.Yaml;
import org.ho.yaml.exception.YamlException;

public class YamlParser {
    public static void main(String[] args) {
        IYamlElement root = YamlParser.parseByFile(new File("script_validate.yml"), "UTF-8");
        System.out.println(root);
        System.out.println("====================");
        HashMap<String, Object> globalParameter = new HashMap<String, Object>();
        globalParameter.put("skk_visitor", new Integer(6));
        globalParameter.put("selection_model", new Hoge());
    }

    public static IYamlElement parseByFile(File f, String encoding) {
        return YamlParser.parseByString(FileUtil.getText((File)f, (String)encoding));
    }

    public static IYamlElement parseByFile(IFile f) throws CoreException {
        try {
            Yaml.config.setEncoding(f.getCharset());
            Map object = (Map)Yaml.load((InputStream)f.getContents());
            IYamlElement root = null;
            root = YamlParser.parse(object);
            root.setIFile(f);
            return root;
        }
        catch (YamlException e) {
            e.printStackTrace();
            try {
                HashMap<String, Integer> attributes = new HashMap<String, Integer>();
                Field lineNumberField = ((Object)((Object)e)).getClass().getDeclaredField("lineNumber");
                lineNumberField.setAccessible(true);
                MarkerUtilities.setLineNumber(attributes, (int)lineNumberField.getInt((Object)e));
                MarkerUtilities.setMessage(attributes, (String)e.getMessage());
                attributes.put("severity", 2);
                MarkerUtilities.createMarker((IResource)f, attributes, (String)"org.eclipse.core.resources.problemmarker");
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
            throw e;
        }
    }

    public static IYamlElement parseByString(String targetString) {
        return YamlParser.parseByString(targetString, "UTF-8");
    }

    public static IYamlElement parseByString(String targetString, String encoding) {
        Yaml.config.setEncoding(encoding);
        Map object = (Map)Yaml.load((String)targetString);
        return YamlParser.parse(object);
    }

    public static <T> T parseByType(String targetString, String encoding, Class<T> clazz) {
        Yaml.config.setEncoding(encoding);
        return (T)Yaml.loadType((String)targetString, clazz);
    }

    public static String dump(Object o) {
        return Yaml.dump((Object)o);
    }

    private static IYamlElement parse(Map object) {
        if (object == null) {
            return null;
        }
        YamlElement root = new YamlElement();
        YamlParser.parse_recurse(root, object);
        return root;
    }

    private static void parse_recurse(IYamlElement parent, Object object) {
        if (object instanceof Map) {
            Map map = (Map)object;
            for (Map.Entry entry : map.entrySet()) {
                StringUtil.nvl(entry.getValue());
                YamlElement child = new YamlElement((String)entry.getKey(), entry.getValue());
                parent.addChild(child);
                if (entry.getValue() instanceof List) {
                    List list = (List)entry.getValue();
                    for (Object o : list) {
                        YamlParser.parse_recurse(child, o);
                    }
                    continue;
                }
                if (!(entry.getValue() instanceof Map)) continue;
                Map child_map = (Map)entry.getValue();
                if (child_map.containsKey("title")) {
                    child.setTitle(StringUtil.nvl(child_map.get("title")));
                    child_map.remove("title");
                }
                if (child_map.containsKey("script")) {
                    ((AbsYamlElement)child).setScript(StringUtil.nvl(child_map.get("script")));
                    child_map.remove("script");
                }
                if (child_map.containsKey("script_engine")) {
                    ((AbsYamlElement)child).setScriptEngineName(StringUtil.nvl(child_map.get("script_engine")));
                    child_map.remove("script_engine");
                }
                YamlParser.parse_recurse(child, child_map);
            }
        } else {
            System.err.println("what???" + object);
        }
    }

    static class Hoge {
        Hoge() {
        }

        public void dump(ElementType t) {
            System.out.println((Object)t);
        }

        public Piyo[] getProjectModel() {
            return new Piyo[]{new Piyo()};
        }
    }

    static class Piyo {
        Piyo() {
        }

        public String toString() {
            return "piyonn ";
        }
    }
}

