/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.yaml.editors.text;

import hiro.yoshioka.util.StringUtil;
import hiro.yoshioka.yaml.dom.IYamlElement;
import hiro.yoshioka.yaml.dom.IYamlMapElement;
import hiro.yoshioka.yaml.editors.text.YamlTextEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class YamlOutlinePage
extends ContentOutlinePage {
    private IYamlElement rootObject;
    private YamlTextEditor editor;
    TreeViewer viewer;

    public YamlOutlinePage(YamlTextEditor editor) {
        this.editor = editor;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.viewer = this.getTreeViewer();
        this.viewer.setContentProvider((IContentProvider)new YamlContentProvider(null));
        this.viewer.setLabelProvider((IBaseLabelProvider)new YamlLabelProvider(null));
        this.viewer.setInput((Object)this.rootObject);
        this.refresh(null);
    }

    public void refresh(IYamlElement targetObj) {
        if (this.viewer.getTree().isDisposed()) {
            return;
        }
        try {
            TreeViewer viewer = this.getTreeViewer();
            viewer.getTree().setVisible(false);
            viewer.cancelEditing();
            viewer.collapseAll();
            this.rootObject = targetObj;
            viewer.setInput((Object)this.rootObject);
            viewer.refresh();
            viewer.getTree().setVisible(true);
        }
        catch (Throwable e) {
            e.printStackTrace();
            try {
                this.viewer.cancelEditing();
                this.viewer.refresh();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    private class YamlContentProvider
    implements ITreeContentProvider {
        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IYamlElement) {
                IYamlElement iyaml = (IYamlElement)parentElement;
                return iyaml.getChildren();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof IYamlElement) {
                IYamlElement iyaml = (IYamlElement)element;
                return iyaml.getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IYamlElement) {
                IYamlElement iyaml = (IYamlElement)element;
                return iyaml.hasChild();
            }
            return this.getChildren(element).length != 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer1, Object obj, Object obj1) {
        }

        private YamlContentProvider() {
        }

        YamlContentProvider(YamlContentProvider yamlcontentprovider) {
            this();
        }
    }

    private class YamlLabelProvider
    extends StyledCellLabelProvider {
        private YamlLabelProvider() {
        }

        YamlLabelProvider(YamlLabelProvider yamllabelprovider) {
            this();
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            StyledString styledString = null;
            if (element instanceof IYamlMapElement) {
                IYamlMapElement yaml = (IYamlMapElement)element;
                styledString = new StyledString(StringUtil.nvl((Object)yaml.getKey()));
                if (yaml.getValue() == null) {
                    styledString.append(" [NULL]", StyledString.COUNTER_STYLER);
                } else {
                    if (!yaml.hasChild()) {
                        styledString.append(String.format(" [%s]", yaml.getValue()), StyledString.QUALIFIER_STYLER);
                    }
                    styledString.append(String.format(" [%s]", yaml.getValue().getClass().getSimpleName()), StyledString.COUNTER_STYLER);
                }
            }
            cell.setText(styledString.toString());
            cell.setStyleRanges(styledString.getStyleRanges());
            super.update(cell);
        }
    }
}

