import hiro.yoshioka.classmanager.ClassManager;
import hiro.yoshioka.sql.notes.NotesRunnerMeta;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.params.DBResourceCapturingFilter;
import hiro.yoshioka.sql.params.DBUserPass;
import hiro.yoshioka.sql.resource.DBRoot;

import java.io.File;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class NotesMetaTest {

	public static void main(java.lang.String[] args) {
		ConnectionProperties p = new ConnectionProperties();

		// dom
		p.setHost("192.168.1.21");
		p.setAuthenticate(new DBUserPass("yuko admin", "password"));

		p.setCaptureWithDDL(false);
		p.setCaptureWithColumnInfo(false);
		p.setCaptureWithViewInfo(false);

		p.setCapturingFilter(DBResourceCapturingFilter.MATCHES);
		// p.addFilePathRegrex(".*hoge.*");
		ClassManager cm = new ClassManager();
		try {
			cm.add_lib(new File("/Users/yonsama/tools/NCSO.jar"));
			ExecutorService ex = Executors.newSingleThreadExecutor();
			Future<DBRoot> future = null;

			future = ex.submit(new NotesRunnerMeta(cm, p));

			try {
				System.out.println(future.get());
			} catch (InterruptedException e) {
				e.printStackTrace();
			} catch (ExecutionException e) {
				e.printStackTrace();
			}
			ex.shutdown();
		} catch (Exception e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
	}
}
