package hiro.yoshioka.ast.sql.oracle.util;

import hiro.yoshioka.ast.sql.AbsSimpleNode;
import hiro.yoshioka.ast.sql.IToken;
import hiro.yoshioka.ast.sql.oracle.ASTOrderByClause;
import hiro.yoshioka.ast.sql.oracle.ASTOrderByElement;
import hiro.yoshioka.ast.sql.oracle.SimpleNode;
import hiro.yoshioka.ast.sql.oracle.WolfSQLParserConstants;
import hiro.yoshioka.sdh.DefaultStringRecordPairData;
import hiro.yoshioka.sdh.StringRecordData;
import hiro.yoshioka.util.StringUtil;

import java.util.ArrayList;
import java.util.List;

public class SimpleOrderbyVisitor extends DefaultSQLNodeVisitor {
	private List<StringRecordData> selectFieldList = new ArrayList<StringRecordData>();
	private String sql_statement;

	public SimpleOrderbyVisitor(String sql) {
		this.sql_statement = sql;
	}

	public List<StringRecordData> getOrderbyColumnList() {
		return selectFieldList;
	}

	String getLine(AbsSimpleNode node) {
		String stext = sql_statement;
		String line = new BackWord(stext).backWord(node.getFirstToken(),
				node.getLastToken());
		return line;
	}

	public class BackWord {
		String fTargetText;

		public BackWord(String targetText) {
			fTargetText = targetText;
		}

		public String backWord(IToken begin, IToken end) {
			String lsp = StringUtil.getThisLineSeparator(fTargetText);
			String[] lineData = fTargetText.split(lsp, -1);
			StringBuffer ret = new StringBuffer();
			for (int i = begin.getBeginLine() - 1; i <= end.getEndLine() - 1; i++) {
				if (i == begin.getBeginLine() - 1) {
					if (i == end.getEndLine() - 1) {
						ret.append(lineData[i].substring(
								begin.getBeginColumn() - 1, end.getEndColumn()));
					} else {
						ret.append(lineData[i].substring(begin.getBeginColumn() - 1));
					}
				} else if (i > begin.getBeginLine() - 1) {
					if (i == end.getEndLine() - 1) {
						ret.append(lineData[i].substring(0, end.getEndColumn()));
					} else {
						ret.append(lineData[i]);
					}
				} else {

					System.out.println("ELSE[" + lineData[i]);
				}
			}
			return ret.toString();
		}

	}

	public Object doJob(SimpleNode node, Object data) {
		SimpleNode n;
		for (int ord = 0; ord < node.jjtGetNumChildren(); ord++) {
			n = (SimpleNode) node.jjtGetChild(ord);
			n.jjtAccept(this, data);
		}
		return data;
	}

	public Object visit(ASTOrderByClause node, Object data) {
		AbsSimpleNode[] nodes = node.getChildren();
		for (int i = 0; i < nodes.length; i++) {
			((SimpleNode) nodes[i]).jjtAccept(this, data);
		}
		return null;
	}

	public Object visit(ASTOrderByElement node, Object data) {
		StringRecordData sr = new StringRecordData(node.getFirstToken()
				.getImage());
		IToken token = node.getLastToken();
		if (token != null) {
			if (token.getKind() == WolfSQLParserConstants.ASC
					|| token.getKind() == WolfSQLParserConstants.DESC) {
				sr.setPair(new DefaultStringRecordPairData<IToken>(token));
			}
		}
		selectFieldList.add(sr);
		return null;
	}

}
