package hiro.yoshioka.ast.sql.util;

import hiro.yoshioka.util.StringUtil;

public class ASTFormatingInfo {
	public boolean fAndOrAfter;

	private boolean doIndentTab;

	private int fIndentSpaceNum = 2;

	private String fIndentString = "";

	public String fSQLStatement;

	public int max_col_len = 80;

	public int mode = StringFormat.MODE_AVG_LENGTH;

	public boolean left;

	public int col_num = 3;

	private boolean expandDecode;

	private boolean multiBlank2blank;

	private int subqueryFold = 2;

	public boolean selectColumnCommentOn;

	@Override
	public String toString() {
		StringBuilder buf = new StringBuilder();
		buf.append("Format Parameters are ...").append(
				StringUtil.LINE_SEPARATOR);
		buf.append(String.format("  Indent use TAB[%s] ", "" + doIndentTab));
		buf.append(String.format("Disp Tab Width[%d] ", fIndentSpaceNum));
		buf.append(StringUtil.LINE_SEPARATOR);
		buf.append(String.format("  max_col_len[%d] ", max_col_len));
		buf.append(String.format("align left[%s] ", "" + left));
		buf.append(StringUtil.LINE_SEPARATOR);
		if (mode == StringFormat.MODE_AVG_LENGTH) {
			buf.append(String.format("  mode[AVG_COLUMN_NAME_SIZE] "));
		} else {
			buf.append(String.format("  mode[MAX_COLUMN_NAME_SIZE] "));
		}
		buf.append(String.format("The number in A line[%d] ", col_num));

		return buf.toString();
	}

	public ASTFormatingInfo(String sqlStatement) {
		fSQLStatement = sqlStatement;
		setIndentInfo(doIndentTab, fIndentSpaceNum);
	}

	public void setSelectColumnCommentOn(boolean selectColumnCommentOn) {
		this.selectColumnCommentOn = selectColumnCommentOn;
	}

	public void setContinuingBlank2aBlank(boolean flag) {
		this.multiBlank2blank = flag;
	}

	public void setExpandDecode(boolean flag) {
		this.expandDecode = flag;
	}

	public void setIndentInfo(boolean doTab, int spaceNum) {
		doIndentTab = doTab;
		fIndentSpaceNum = spaceNum;
		if (doIndentTab) {
			fIndentString = "\t";
			return;
		}
		StringBuffer buf = new StringBuffer();
		for (int i = 0; i < fIndentSpaceNum; i++) {
			buf.append(" ");
		}
		fIndentString = buf.toString();
	}

	public String getIndentString() {
		return fIndentString;
	}

	/**
	 * @return
	 */
	public boolean isSimpleCodition() {
		return false;
	}

	/**
	 * @return
	 */
	public boolean afterAndOr() {
		// TODO Auto-generated method stub
		return fAndOrAfter;
	}

	/**
	 * @return
	 */
	public String getSQLText() {
		return fSQLStatement;
	}

	public boolean expandDecode() {
		return expandDecode;
	}

	public boolean continuingBlank2aBlank() {
		return multiBlank2blank;
	}

	public int getSubqueryFold() {
		return subqueryFold;
	}

	public void setSubqueryFold(int subqueryFold) {
		this.subqueryFold = subqueryFold;
	}

}