package hiro.yoshioka.ast.sql.util;

import hiro.yoshioka.ast.sql.IToken;
import hiro.yoshioka.ast.sql.notes.util.WolfNotesParserUtil;
import hiro.yoshioka.sql.engine.DominoTransactionRequest;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.engine.TransactionRequest;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.DBRoot;
import hiro.yoshioka.sql.resource.IDBTable;
import hiro.yoshioka.sql.resource.notes.NotesDBTable;
import hiro.yoshioka.sql.util.BindDialog;
import hiro.yoshioka.sql.util.SQLHistroyManager;
import hiro.yoshioka.util.StringUtil;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.List;

import org.eclipse.swt.widgets.Display;

public class WolfNotesProposalParserUtil extends WolfProposalParserUtil
		implements IProposalableParserUtil {

	public WolfNotesProposalParserUtil(File file, DBRoot root)
			throws FileNotFoundException {
		super(file, root);
	}

	public WolfNotesProposalParserUtil(String string, DBRoot root) {
		super(string, root);
	}

	public List<IToken> getAllErrorTokens() {
		return Collections.EMPTY_LIST;
	}

	@Override
	public TransactionRequest createTransactionRequest(ConnectionProperties p) {
		DominoTransactionRequest req = null;
		if (startsWithTrigFncProc()) {
			dumpSQLStatement();
			req = new DominoTransactionRequest(
					SQLOperationType.CREATE_TRIG_FNC_PROC, p,
					getSQLStatements());
		} else if (canDoBatchExecute()) {
			req = new DominoTransactionRequest(SQLOperationType.EXECUTE_BAT, p,
					getSQLStatements());
		} else {
			SQLOperationType operationCode;
			Object[] bindsObjects = null;
			BindInfo[] binds = binds();
			if (binds == null || binds.length == 0) {
				fLogger.trace("BIND LENGTH 0"); //$NON-NLS-1$
				if (doQuery()) {
					operationCode = SQLOperationType.PREPARED_EXECUTE_QUERY;
				} else {
					operationCode = SQLOperationType.PREPARED_EXECUTE;
				}
			} else {
				// TODO: bindDialog
				SQLHistroyManager.getInstance().setBindValue(getSQLStatement(),
						binds);
				BindDialog dialog = new BindDialog(Display.getCurrent()
						.getActiveShell(), binds);
				dialog.setBlockOnOpen(true);
				if (dialog.open() == BindDialog.CANCEL) {
					fLogger.info("CANSELED..............................."); //$NON-NLS-1$
					return null;
				}
				bindsObjects = new Object[binds.length];
				fLogger.info("BIND LENGTH [" + bindsObjects.length + "]"); //$NON-NLS-1$ //$NON-NLS-2$
				for (int i = 0; i < bindsObjects.length; i++) {
					bindsObjects[i] = binds[i];
					fLogger.info("BIND[" + i + "] [" + bindsObjects[i] //$NON-NLS-1$ //$NON-NLS-2$
							+ "] class[" + bindsObjects[i].getClass() + "]"); //$NON-NLS-1$ //$NON-NLS-2$
				}
				if (doQuery()) {
					operationCode = SQLOperationType.PREPARED_EXECUTE_QUERY;
				} else {
					operationCode = SQLOperationType.PREPARED_EXECUTE;
				}
			}
			req = new DominoTransactionRequest(operationCode, p,
					getSQLStatement(), bindsObjects, getFirstTable());
			req.setDominoSearchQuery(getDominoSearchQuery());

		}
		return req;
	}

	public String getDominoSearchQuery() {
		IDBTable table = getFirstTable();
		if (table instanceof NotesDBTable) {
			return WolfNotesParserUtil.getSearchFormQuery((NotesDBTable) table);
		} else {
			fLogger.fatal("missing NotesDBTable");
			return StringUtil.EMPTY_STRING;
		}
	}

	@Override
	public String getFormattedString(ASTFormatingInfo info) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getSpecialTokenString() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void clearAlias() {
		// TODO Auto-generated method stub

	}

	@Override
	public ASTAssist getASTAssist() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public ASTProposalableAssist getASTProposalableAssist() {
		// TODO Auto-generated method stub
		return null;
	}

}
